/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.ai.findings;

import com.teamscale.core.ai.LlmPrompt;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.index.ai.findings.FindingResolutionException;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public enum EAiFindingResolutionPromptGenerator {
    LINE_REF_WITH_DESCRIPTION{

        @Override
        protected LlmPrompt generatePrompt(ELanguage language, String code, int lineNumber, String findingMessage, String findingDescription) {
            return new LlmPrompt("Following you find a piece of code written in %s, a short message of the issue, and then a longer description of the issue. Answer with an improved version of the code with the issue removed. If this is not possible or you do not know how to do it, then answer 'FAILED'. If you think this is a false positive, then answer 'FALSE_POSITIVE'. Answer only with the resulting code, which should be a full replacement of the provided code, or the single word 'FAILED' or 'FALSE_POSITIVE'. The issue is in line %d of the provided code.\n\nMessage:\n%s\n\nDescription:\n%s\n\nCode:\n".formatted(language.getReadableName(), lineNumber, findingMessage, findingDescription), new String[]{StringUtils.ensureEndsWith((String)code, (String)"\n")});
        }
    }
    ,
    LINE_REF_NO_DESCRIPTION{

        @Override
        protected LlmPrompt generatePrompt(ELanguage language, String code, int lineNumber, String findingMessage, String findingDescription) {
            return new LlmPrompt("Following you find a piece of code written in %s and a short message of the issue. Answer with an improved version of the code with the issue removed. If this is not possible or you do not know how to do it, then answer 'FAILED'. If you think this is a false positive, then answer 'FALSE_POSITIVE'. Answer only with the resulting code, which should be a full replacement of the provided code, or the single word 'FAILED' or 'FALSE_POSITIVE'. The issue is in line %d of the provided code.\n\nMessage:\n%s\n\nCode:\n".formatted(language.getReadableName(), lineNumber, findingMessage), new String[]{StringUtils.ensureEndsWith((String)code, (String)"\n")});
        }
    }
    ,
    INLINE_ISSUE{
        private static final Pattern NEW_LINE = Pattern.compile("[\\n\\r]");

        @Override
        protected LlmPrompt generatePrompt(ELanguage language, String code, int lineNumber, String findingMessage, String findingDescription) {
            List codeLines = StringUtils.splitLinesAsList((String)code);
            codeLines.add(lineNumber - 1, "// ISSUE: " + StringUtils.replaceAll((String)findingMessage, (Pattern)NEW_LINE, (String)" "));
            String patchedCode = StringUtils.concat((Iterable)codeLines, (String)"\n");
            return new LlmPrompt("Following you find a piece of code written in %s. This code contains a comment starting with the word \"ISSUE:\", followed by a short message describing the issue. Answer with an improved version of the code with the issue removed. If this is not possible or you do not know how to do it, then answer 'FAILED'. If you think this is a false positive, then answer 'FALSE_POSITIVE'. Answer only with the resulting code, which should be a full replacement of the provided code, or the single word 'FAILED' or 'FALSE_POSITIVE'.\n".formatted(language.getReadableName()), new String[]{StringUtils.ensureEndsWith((String)patchedCode, (String)"\n")});
        }
    };

    public static final EAiFindingResolutionPromptGenerator DEFAULT;

    public PromptGenerationResult generatePrompt(TrackedFinding finding, TokenElementInfo tokenElement, FindingTypeDescription findingDescription) throws FindingResolutionException {
        int startOffset;
        ElementLocation elementLocation = finding.getLocation();
        if (!(elementLocation instanceof TextRegionLocation)) {
            throw new FindingResolutionException("Finding resolution suggestion only works for findings with text region locations!");
        }
        TextRegionLocation location = (TextRegionLocation)elementLocation;
        Optional<ShallowEntity> surroundingEntity = EAiFindingResolutionPromptGenerator.findSurroundingEntity(tokenElement, location);
        if (surroundingEntity.isEmpty()) {
            LlmPrompt prompt = this.generatePrompt(tokenElement.getLanguage(), tokenElement.getText(), location.getRawStartLine(), finding.getMessage(), findingDescription.getDescription());
            return new PromptGenerationResult(prompt, 0, tokenElement.getText().length());
        }
        ShallowEntity outerEntity = surroundingEntity.get();
        int lineOffset = outerEntity.getStartLine();
        for (startOffset = outerEntity.getStartOffset(); startOffset > 0 && tokenElement.getText().charAt(startOffset - 1) != '\n'; --startOffset) {
        }
        int endOffset = outerEntity.getEndOffset() + 1;
        String oldMethodContent = tokenElement.getText().substring(startOffset, endOffset);
        LlmPrompt prompt = this.generatePrompt(tokenElement.getLanguage(), oldMethodContent, location.getRawStartLine() - lineOffset + 1, finding.getMessage(), findingDescription.getDescription());
        return new PromptGenerationResult(prompt, startOffset, endOffset);
    }

    protected abstract LlmPrompt generatePrompt(ELanguage var1, String var2, int var3, String var4, String var5);

    private static @NonNull Optional<ShallowEntity> findSurroundingEntity(TokenElementInfo element, TextRegionLocation location) throws FindingResolutionException {
        Optional lineEntity = ShallowEntityTraversalUtils.findEntityForLine((int)location.getRawStartLine(), element.getRawShallowEntities());
        if (lineEntity.isEmpty()) {
            throw new FindingResolutionException("Could not determine AST node containing the finding's start line.");
        }
        Optional methodEntity = ShallowEntityTraversalUtils.findEntityOrParentEntity((ShallowEntity)((ShallowEntity)lineEntity.get()), EAiFindingResolutionPromptGenerator::isMeaningfulEntity);
        ShallowEntity outerEntity = methodEntity.orElseGet(() -> (ShallowEntity)CollectionUtils.getLast((List)ShallowEntityTraversalUtils.findMatchingParentEntities((ShallowEntity)((ShallowEntity)lineEntity.get()), x -> true)));
        if (outerEntity == null || outerEntity.getEndLine() < location.getRawEndLine()) {
            return Optional.empty();
        }
        return Optional.of(outerEntity);
    }

    private static boolean isMeaningfulEntity(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE || entity.getType() == EShallowEntityType.METHOD && !"lambda".equals(entity.getSubtype());
    }

    static {
        DEFAULT = LINE_REF_WITH_DESCRIPTION;
    }

    public record PromptGenerationResult(LlmPrompt prompt, int replacedTextRangeStartOffset, int replacedTextRangeEndOffset) {
    }
}

