/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.TypeDependencyInfo;
import com.teamscale.index.architecture.commons.EAssessmentType;
import com.teamscale.index.architecture.commons.EPolicyType;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class DependencyPolicyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String from;
    private final String to;
    private final List<Point> points;
    private final @Nullable EPolicyType policyType;
    private final @Nullable EAssessmentType assessmentType;
    private final List<TypeDependencyInfo> dependencies;
    private final List<TypeDependencyInfo> toleratedDependencies;

    private DependencyPolicyInfo(Builder builder) {
        this.from = Objects.requireNonNull(builder.from, "from");
        this.to = Objects.requireNonNull(builder.to, "to");
        this.policyType = builder.policyType;
        this.assessmentType = builder.assessmentType;
        this.points = new ArrayList<Point>(builder.points);
        this.dependencies = new ArrayList<TypeDependencyInfo>(builder.dependencies);
        this.toleratedDependencies = new ArrayList<TypeDependencyInfo>(builder.toleratedDependencies);
    }

    public @Nullable EAssessmentType getAssessmentType() {
        return this.assessmentType;
    }

    public @Nullable EPolicyType getPolicyType() {
        return this.policyType;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public UnmodifiableCollection<TypeDependencyInfo> getToleratedDependencies() {
        return CollectionUtils.asUnmodifiable(this.toleratedDependencies);
    }

    public UnmodifiableList<TypeDependencyInfo> getDependencies() {
        return CollectionUtils.asUnmodifiable(this.dependencies);
    }

    public UnmodifiableList<Point> getPoints() {
        return CollectionUtils.asUnmodifiable(this.points);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyPolicyInfo that = (DependencyPolicyInfo)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.points, that.points) && this.policyType == that.policyType && this.assessmentType == that.assessmentType && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.toleratedDependencies, that.toleratedDependencies);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.to, this.points, this.policyType, this.assessmentType, this.dependencies, this.toleratedDependencies});
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String from;
        private String to;
        private List<Point> points = new ArrayList<Point>();
        private EPolicyType policyType;
        private EAssessmentType assessmentType;
        private List<TypeDependencyInfo> dependencies = new ArrayList<TypeDependencyInfo>();
        private List<TypeDependencyInfo> toleratedDependencies = new ArrayList<TypeDependencyInfo>();

        protected Builder() {
        }

        protected Builder(DependencyPolicyInfo dependencyPolicyInfo) {
            this.from = dependencyPolicyInfo.from;
            this.to = dependencyPolicyInfo.to;
            this.points = new ArrayList<Point>(dependencyPolicyInfo.points);
            this.policyType = dependencyPolicyInfo.policyType;
            this.assessmentType = dependencyPolicyInfo.assessmentType;
            this.dependencies = new ArrayList<TypeDependencyInfo>(dependencyPolicyInfo.dependencies);
            this.toleratedDependencies = new ArrayList<TypeDependencyInfo>(dependencyPolicyInfo.toleratedDependencies);
        }

        public Builder withFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder withTo(String to) {
            this.to = to;
            return this;
        }

        public Builder withPoints(Collection<Point> points) {
            points.forEach(this::withPoint);
            return this;
        }

        public Builder withPoint(Point point) {
            this.points.add(new Point(point));
            return this;
        }

        public Builder withPolicyType(EPolicyType policyType) {
            this.policyType = policyType;
            return this;
        }

        public Builder withAssessmentType(EAssessmentType assessmentType) {
            this.assessmentType = assessmentType;
            return this;
        }

        public Builder withDependencies(Collection<TypeDependencyInfo> dependencies) {
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder withDependency(TypeDependencyInfo dependency) {
            this.dependencies.add(dependency);
            return this;
        }

        public Builder withToleratedDependencies(Collection<TypeDependencyInfo> toleratedDependencies) {
            this.toleratedDependencies.addAll(toleratedDependencies);
            return this;
        }

        public Builder withToleratedDependency(TypeDependencyInfo toleratedDependency) {
            this.toleratedDependencies.add(toleratedDependency);
            return this;
        }

        public DependencyPolicyInfo build() {
            return new DependencyPolicyInfo(this);
        }
    }
}

