/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.incremental.ComponentDependencyContainer;
import com.teamscale.index.architecture.incremental.DependencyValueClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="architecture-component-dependency", options={EStorageOption.BRANCHED})
public class ArchitectureComponentDependencyIndex
extends IndexBase
implements IProjectIndex {
    private final ValueIndex<DependencyValueClass> delegate;
    private static final String SEPARATOR = "##";
    public static final String INDEX_NAME = "architecture-component-dependency";

    public ArchitectureComponentDependencyIndex(IStore store) {
        super(store);
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setArchitecturesAndChanges(String architectureName, List<Dependency> dependencies) throws StorageException {
        PairList values = new PairList();
        for (Dependency dependency : dependencies) {
            String key = ArchitectureComponentDependencyIndex.makeKey(architectureName, dependency.getSource().getName(), dependency.getTarget().getName());
            DependencyValueClass dto = new DependencyValueClass(dependency);
            values.add((Object)key, (Object)dto);
        }
        this.delegate.setValues(values);
    }

    public List<DependencyValueClass> getDependencies(String architectureName) throws StorageException {
        PairList entriesStartingWith = this.delegate.getEntriesStartingWith(architectureName + SEPARATOR);
        return entriesStartingWith.extractSecondList();
    }

    public List<DependencyValueClass> getDependencies(String architectureName, PairList<String, String> componentNames) throws StorageException {
        ArrayList<String> keys = new ArrayList<String>();
        for (Pair componentName : componentNames) {
            String key = ArchitectureComponentDependencyIndex.makeKey(architectureName, (String)componentName.getFirst(), (String)componentName.getSecond());
            keys.add(key);
        }
        return this.delegate.getValues(keys);
    }

    public void removeDependencies(List<String> architectureNames) throws StorageException {
        this.delegate.removeEntriesStartingWith(architectureNames);
    }

    public void removeDependencies(String architectureName, List<Dependency> dependencies) throws StorageException {
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (Dependency dependency : dependencies) {
            String key = ArchitectureComponentDependencyIndex.makeKey(architectureName, dependency.getSource().getName(), dependency.getTarget().getName());
            keysToDelete.add(key);
        }
        this.delegate.removeValues(keysToDelete);
    }

    public void removeDependencies(String architectureName, Map<String, ComponentDependencyContainer.ComponentDependency> deletedDependencies) throws StorageException {
        ArrayList<String> keysToDelete = new ArrayList<String>();
        PairList keysToUpdate = new PairList();
        for (Map.Entry<String, ComponentDependencyContainer.ComponentDependency> dependency : deletedDependencies.entrySet()) {
            String key = ArchitectureComponentDependencyIndex.makeKey(architectureName, dependency.getValue().sourceComponent(), dependency.getValue().targetComponent());
            DependencyValueClass value = (DependencyValueClass)this.delegate.getValue(key);
            if (value == null) continue;
            value.removeTypeDependencies(dependency.getValue().typeDependencies());
            if (value.getDependencies().isEmpty()) {
                keysToDelete.add(key);
                continue;
            }
            keysToUpdate.add((Object)key, (Object)value);
        }
        this.delegate.removeValues(keysToDelete);
        this.delegate.setValues(keysToUpdate);
    }

    private static String makeKey(String architectureName, String source, String target) {
        return architectureName + SEPARATOR + source + SEPARATOR + target;
    }
}

