/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.incremental.ArchitectureFileDependenciesIndex;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.dependencies.DependencyListIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.jspecify.annotations.Nullable;

public class ComponentDependencyContainer {
    private final ArchitectureTypeDependenciesIndex typeDependenciesIndexLastCommit;
    private final DependencyListIndex dependencyListIndex;
    private final DependencyListIndex dependencyListIndexLastCommit;
    private final KeyDelta fileScopeDelta;
    private final KeyDelta typeScopeDelta;
    private SetMap<String, String> changedTypeDependencies;
    private PairList<String, String> deletedTypeDependencies;
    private PairList<String, String> deletedFileDependencies;
    private final SetMap<String, String> typeDependencies = new SetMap();
    private final SetMap<String, String> fileDependencies = new SetMap();

    public ComponentDependencyContainer(KeyDelta fileScopeDelta, KeyDelta typeScopeDelta, ArchitectureFileDependenciesIndex fileDependenciesIndex, ArchitectureTypeDependenciesIndex typeDependenciesIndex, ArchitectureTypeDependenciesIndex typeScopeIndexLastCommit, DependencyListIndex dependencyIndex, DependencyListIndex dependencyIndexLastCommit, Set<String> matchedFiles, Set<String> matchedTypes) throws StorageException {
        this.fileScopeDelta = fileScopeDelta;
        this.typeScopeDelta = typeScopeDelta;
        this.dependencyListIndex = dependencyIndex;
        this.dependencyListIndexLastCommit = dependencyIndexLastCommit;
        this.typeDependenciesIndexLastCommit = typeScopeIndexLastCommit;
        this.fileDependencies.addAll(fileDependenciesIndex.getDependencies(new ArrayList<String>(matchedFiles)));
        this.typeDependencies.addAll(typeDependenciesIndex.getDependencies(new ArrayList<String>(matchedTypes)));
    }

    public SetMap<String, String> getDependencies(boolean fileBased, List<String> paths) throws StorageException {
        if (fileBased) {
            return ComponentDependencyContainer.getDependenciesFromCache(this.fileDependencies, paths);
        }
        return ComponentDependencyContainer.getDependenciesFromCache(this.typeDependencies, paths);
    }

    private static SetMap<String, String> getDependenciesFromCache(SetMap<String, String> dependencies, List<String> paths) {
        SetMap result = new SetMap();
        for (String path : paths) {
            Set collection = (Set)dependencies.getCollection((Object)path);
            if (collection == null) continue;
            result.addAll((Object)path, (Collection)collection);
        }
        return result;
    }

    public PairList<String, String> getDeletedComponentDependencies(boolean fileBased) throws StorageException {
        if (fileBased) {
            return this.getDeletedFileDependencies();
        }
        return this.getDeletedTypeDependencies();
    }

    private synchronized PairList<String, String> getDeletedTypeDependencies() throws StorageException {
        if (this.deletedTypeDependencies != null) {
            return this.deletedTypeDependencies;
        }
        this.deletedTypeDependencies = new PairList();
        List addedOrChangedKeysAsStrings = this.typeScopeDelta.getAllKeysAsStrings();
        SetMap<String, String> scopeLastCommit = this.typeDependenciesIndexLastCommit.getDependencies(addedOrChangedKeysAsStrings);
        for (Map.Entry entry : scopeLastCommit.entrySet()) {
            Set dependencies = (Set)this.getChangedTypeDependencies().getCollectionOrEmpty((Object)((String)entry.getKey()));
            HashSet strings = CollectionUtils.differenceSet((Collection)((Collection)entry.getValue()), (Collection[])new Collection[]{dependencies});
            for (String dependency : strings) {
                this.deletedTypeDependencies.add((Object)((String)entry.getKey()), (Object)dependency);
            }
        }
        return this.deletedTypeDependencies;
    }

    private synchronized PairList<String, String> getDeletedFileDependencies() throws StorageException {
        if (this.deletedFileDependencies == null) {
            this.deletedFileDependencies = new PairList();
            List uniformPaths = this.fileScopeDelta.getAllKeysAsStrings();
            List<@Nullable ArrayList<String>> dependenciesLastCommit = this.dependencyListIndexLastCommit.getDependencies(uniformPaths);
            List<@Nullable ArrayList<String>> currentDependencies = this.dependencyListIndex.getDependencies(uniformPaths);
            for (int i = 0; i < currentDependencies.size(); ++i) {
                List strings = dependenciesLastCommit.get(i);
                if (strings == null) continue;
                List strings1 = currentDependencies.get(i);
                if (strings1 == null) {
                    strings1 = Collections.emptyList();
                }
                HashSet deletedDependencies = CollectionUtils.differenceSet((Collection)strings, (Collection[])new Collection[]{strings1});
                String key = (String)uniformPaths.get(i);
                for (String dependency : deletedDependencies) {
                    this.deletedFileDependencies.add((Object)key, (Object)dependency);
                }
            }
        }
        return this.deletedFileDependencies;
    }

    private synchronized SetMap<String, String> getChangedTypeDependencies() throws StorageException {
        if (this.changedTypeDependencies == null) {
            List addedOrChangedKeysAsStrings = this.typeScopeDelta.getAddedOrChangedKeysAsStrings();
            this.changedTypeDependencies = this.getDependencies(false, addedOrChangedKeysAsStrings);
        }
        return this.changedTypeDependencies;
    }

    public record ComponentDependency(String sourceComponent, String targetComponent, List<TypeDependency> typeDependencies) {
        public void addTypeDependency(TypeDependency dependency) {
            this.typeDependencies.add(dependency);
        }
    }
}

