/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.checks;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;

@Check(name="Custom Exception Definition", groupName="Exception Handling", defaultEnablement=EFindingEnablement.OFF, languages={ELanguage.VB, ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CustomExceptionDefinitionCheck
extends CheckImplementationBase {
    public static final String CHECK_NAME = "Custom Exception Definition";
    public static final String GROUP_NAME = "Exception Handling";
    public static final String MESSAGE_PREFIX = "Custom Exception Definition which inherits from: ";

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        List superclass = switch (this.context.getLanguage()) {
            case ELanguage.JAVA -> LanguageFeatureParser.JAVA.getSuperclass(entity);
            case ELanguage.CS -> LanguageFeatureParser.CS.getSuperclass(entity);
            case ELanguage.VB -> LanguageFeatureParser.VB.getSuperclass(entity);
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(this.context.getLanguage()));
        };
        if (!superclass.isEmpty() && CustomExceptionDefinitionCheck.isExceptionClassName(TokenStreamTextUtils.concatTokenTexts((List)superclass))) {
            this.buildFinding(MESSAGE_PREFIX + TokenStreamTextUtils.concatTokenTexts((List)superclass), this.buildLocation().forTokens(superclass)).createAndStore();
        }
    }

    private static boolean isExceptionClassName(String tokenText) {
        return tokenText.endsWith("Exception") || tokenText.endsWith("Error") || tokenText.equals("Throwable") || tokenText.equals("java.lang.Throwable");
    }
}

