/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.analysis.PeriodicMaintenanceJob;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.index.backup.TemporaryFileIndex;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.jetbrains.annotations.VisibleForTesting;

@PeriodicMaintenanceJob(cronExpression="35 3 * * *")
public class TemporaryFileIndexCleanupTrigger
extends MaintenanceTriggerBase {
    private static final Duration TEMPORARY_FILE_KEEP_TIME = Duration.ofDays(7L);

    public void execute() throws Exception {
        TemporaryFileIndex temporaryFileIndex = (TemporaryFileIndex)this.indexLayer.openGlobalIndex(TemporaryFileIndex.class);
        TemporaryFileIndexCleanupTrigger.cleanTemporaryFileIndex(temporaryFileIndex, DateTimeUtils.now());
    }

    @VisibleForTesting
    static void cleanTemporaryFileIndex(TemporaryFileIndex temporaryFileIndex, Instant now) throws StorageException {
        List<TemporaryFileIndex.TemporaryFileDescriptor> filesToDelete = temporaryFileIndex.listFiles().stream().filter(temporaryFileDescriptor -> Duration.between(temporaryFileDescriptor.lastAccessTime(), now).compareTo(TEMPORARY_FILE_KEEP_TIME) >= 0).toList();
        for (TemporaryFileIndex.TemporaryFileDescriptor toDelete : filesToDelete) {
            temporaryFileIndex.deleteFile(toDelete.fileName());
        }
    }
}

