/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.read;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.StorageMigrator;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.index.backup.BackupUtils;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.ExternalUploadIndexRepairer;
import com.teamscale.index.backup.MigratedZipFile;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.BackupReadingParameters;
import com.teamscale.index.backup.read.EncryptionAwareStoreImporter;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.external.ExternalAnalysisResultIndex;
import com.teamscale.index.external.ExternalUploadIndexBase;
import com.teamscale.index.migration.MigrateVersion117WriteSapSystemIdToSapSystemConnection;
import com.teamscale.index.reviews.ElementReviewUploadIndex;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.engine.persistence.store.util.PartitionedStorageSystem;
import org.conqat.engine.persistence.store.util.SingleStorageSystemProvider;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.engine.persistence.store.util.StoreFactory;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class ProjectStoreImporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Class<? extends ExternalUploadIndexBase<? extends Serializable>>> UPLOAD_STORES = new HashMap<String, Class<? extends ExternalUploadIndexBase<? extends Serializable>>>();
    private final IndexLayer transactionalMigrationIndexLayer;
    private final StorageMigrator storageMigrator;
    private final ICancelable cancelable;
    private final Map<PublicProjectId, PublicProjectId> clashingProjectIdMappings;
    private final EStorageSystemVersion sourceVersion;
    private final BackupReadingParameters parameters;
    private final StoreFactory storeFactory;
    private final EncryptionAwareStoreImporter storeImporter;

    public ProjectStoreImporter(IndexLayer transactionalMigrationIndexLayer, ICancelable cancelable, Map<PublicProjectId, PublicProjectId> clashingProjectIdMappings, EStorageSystemVersion sourceVersion, BackupReadingParameters parameters, StoreFactory storeFactory, EncryptionAwareStoreImporter storeImporter) throws StorageException {
        this.transactionalMigrationIndexLayer = transactionalMigrationIndexLayer;
        this.storageMigrator = new StorageMigrator(sourceVersion, (IFactory)storeFactory);
        this.cancelable = cancelable;
        this.clashingProjectIdMappings = clashingProjectIdMappings;
        this.sourceVersion = sourceVersion;
        this.parameters = parameters;
        this.storeFactory = storeFactory;
        this.storeImporter = storeImporter;
    }

    public void importStoresForProject(ProjectInfo projectInfo, boolean projectExists, BackupImportStatus.ImportProgress projectImportProgress, MigrateVersion117WriteSapSystemIdToSapSystemConnection sapSystemIdMigrator, MigratedZipFile backupFile) throws StorageException {
        if (projectImportProgress.getStatus() == EBackupStatus.FAILURE) {
            return;
        }
        SchemaAwareStorageSystem migratingProjectStorageSystem = this.storageMigrator.decorate(this.transactionalMigrationIndexLayer).openProjectStorageSystem(projectInfo.getInternalId());
        try {
            this.importProjectStores(projectInfo, projectExists, projectImportProgress, sapSystemIdMigrator, migratingProjectStorageSystem, backupFile);
        }
        catch (Throwable e) {
            throw new StorageException("Importing stores failed for project \"" + projectInfo.getName() + "\" (ID " + String.valueOf(projectInfo.getPrimaryPublicId()) + ")\n", e);
        }
        this.storageMigrator.flushBatchMigrationsForOpenStorageSystems();
        projectImportProgress.setStatusMessage("Import completed");
        projectImportProgress.setStatus(EBackupStatus.SUCCESS);
    }

    private void importProjectStores(ProjectInfo projectInfo, boolean projectExists, BackupImportStatus.ImportProgress projectImportProgress, MigrateVersion117WriteSapSystemIdToSapSystemConnection sapSystemIdMigrator, SchemaAwareStorageSystem migratingProjectStorageSystem, MigratedZipFile backupFile) throws IOException, ExecutionCanceledException, StorageException, MigrationException {
        if (projectInfo.getParentProjectId().isPresent() && !projectInfo.isConfigurationCompleted()) {
            LOGGER.error("Ignored importing stores for project {}, Parent project does not exist.", (Object)projectInfo.getName());
            return;
        }
        for (ZipArchiveEntry entry : backupFile.getEntries()) {
            this.cancelable.verifyNotCanceled();
            Optional<Pair<PublicProjectId, String>> maybeProjectAndStoreName = ProjectStoreImporter.getProjectAndStoreName(entry);
            if (maybeProjectAndStoreName.isEmpty()) continue;
            Pair<PublicProjectId, String> projectAndStoreName = maybeProjectAndStoreName.get();
            PublicProjectId projectIdFromEntry = (PublicProjectId)projectAndStoreName.getFirst();
            if (this.clashingProjectIdMappings.containsKey(projectIdFromEntry)) {
                projectIdFromEntry = this.clashingProjectIdMappings.get(projectIdFromEntry);
            }
            String storeNameFromEntry = (String)projectAndStoreName.getSecond();
            if (!projectInfo.getPublicIds().contains((Object)projectIdFromEntry) || !this.storageMigrator.shouldImportStore(storeNameFromEntry)) continue;
            projectImportProgress.setStatusMessage("Importing store '" + storeNameFromEntry + "' ...");
            try {
                this.importProjectStore(backupFile, entry, projectImportProgress, projectIdFromEntry, projectInfo.getInternalId(), projectExists, migratingProjectStorageSystem, storeNameFromEntry, sapSystemIdMigrator);
            }
            catch (IOException | StorageException e) {
                throw new IOException("Error importing store '" + storeNameFromEntry + "' for project " + String.valueOf(projectImportProgress.getProject()), e);
            }
        }
    }

    private void importProjectStore(MigratedZipFile backupFile, ZipArchiveEntry entry, BackupImportStatus.ImportProgress projectImportProgress, PublicProjectId publicProjectId, InternalProjectId internalProjectId, boolean projectExists, SchemaAwareStorageSystem migratingProjectStorageSystem, String storeName, MigrateVersion117WriteSapSystemIdToSapSystemConnection sapSystemIdMigrator) throws StorageException, IOException, ExecutionCanceledException, MigrationException {
        if (storeName.equals("project-options") && this.sourceVersion.ordinal() < EStorageSystemVersion.STORAGE_SYSTEM_V117.ordinal()) {
            sapSystemIdMigrator.importProjectOptionsStoreAndMigrateSapSystemId(backupFile, entry, publicProjectId, migratingProjectStorageSystem, storeName, projectImportProgress);
            return;
        }
        if (!migratingProjectStorageSystem.hasIndex(storeName)) {
            LOGGER.error("Ignored store " + storeName + " (not configured in project " + String.valueOf(publicProjectId) + ")");
            return;
        }
        if (projectExists && ProjectStoreImporter.isStoreIgnoredForIncrementalUpdate(storeName)) {
            LOGGER.info("Ignored store " + storeName + " as this is only imported when project does not yet exist.");
            return;
        }
        if (ProjectStoreImporter.isExternalUploadStore(storeName)) {
            this.importExternalUploadIndex(entry, publicProjectId, internalProjectId, (SchemaAwareStorageSystem)this.transactionalMigrationIndexLayer.openProjectStorageSystem((IProjectId)internalProjectId), storeName, projectExists, projectImportProgress);
        } else {
            this.storeImporter.importStore(entry, migratingProjectStorageSystem.openStore(storeName), this.cancelable);
        }
    }

    private void importExternalUploadIndex(ZipArchiveEntry entry, PublicProjectId publicProjectId, InternalProjectId internalProjectId, SchemaAwareStorageSystem existingUpToDateProjectStorageSystem, String storeName, boolean projectExists, BackupImportStatus.ImportProgress projectImportProgress) throws IOException, StorageException, ExecutionCanceledException {
        this.cancelable.verifyNotCanceled();
        LOGGER.trace("importExternalUploadIndex: publicProjectId='{}', internalProjectId='{}', storeName='{}', projectExists={}", (Object)publicProjectId, (Object)internalProjectId, (Object)storeName, (Object)projectExists);
        PartitionedStorageSystem.SingleStoreBasedStorageSystem temporaryStorageSystem = new PartitionedStorageSystem.SingleStoreBasedStorageSystem(this.storeFactory.create(), 0);
        StorageUtils.copyStore((IStore)existingUpToDateProjectStorageSystem.openStore("_meta"), (IStore)temporaryStorageSystem.openStore("_meta"));
        projectImportProgress.setStatusMessage("Importing '" + storeName + "' Step 1/3 (Loading store from archive) ...");
        this.importStoreWithMigration(entry, internalProjectId, storeName, (IStorageSystem)temporaryStorageSystem);
        IStore migratedStore = temporaryStorageSystem.openStore(storeName);
        IStore existingStore = existingUpToDateProjectStorageSystem.openStore(storeName);
        projectImportProgress.setStatusMessage("Importing '" + storeName + "' Step 2/3 (Creating temporary backup of existing store) ...");
        IStore tempOriginalStore = this.storeFactory.create();
        StorageUtils.copyStore((IStore)existingStore, (IStore)tempOriginalStore);
        projectImportProgress.setStatusMessage("Importing '" + storeName + "' Step 3/3 (Merging imported and existing stores) ...");
        StorageUtils.copyStore((IStore)migratedStore, (IStore)existingStore);
        CompressingStore compressingOutputStore = new CompressingStore(existingStore);
        ExternalUploadIndexRepairer.ExternalUploadStoreValidationResult externalUploadStoreValidationResult = ExternalUploadIndexRepairer.validateStore(compressingOutputStore);
        if (!externalUploadStoreValidationResult.needsRepair()) {
            return;
        }
        LOGGER.warn("Rollback is necessary for '{}' during import of '{}'", (Object)storeName, (Object)publicProjectId);
        projectImportProgress.setStatusMessage("Repairing store '" + storeName + "' ...");
        this.cancelable.verifyNotCanceled();
        Map<String, Long> inconsistentCommitsByBranch = externalUploadStoreValidationResult.invalidParentRelations();
        ExternalUploadIndexRepairer.performRollbackForInconsistentBranches(compressingOutputStore, inconsistentCommitsByBranch);
        StorageUtils.copyStore((IStore)tempOriginalStore, (IStore)existingStore);
        if (EFeatureToggle.DISABLE_AUTO_REPAIR_INCONSISTENT_COMMITS_ON_BACKUP_IMPORT.isEnabled()) {
            LOGGER.warn("Inconsistency in store '{}' for project '{}' will not be repaired because the feature toggle '{}' is active. We recommend not using this feature toggle as it can lead to further problems with backups and, potentially, loss of data.", (Object)storeName, (Object)publicProjectId, (Object)EFeatureToggle.DISABLE_AUTO_REPAIR_INCONSISTENT_COMMITS_ON_BACKUP_IMPORT.getId());
            return;
        }
        LOGGER.warn("Attempting to repair inconsistency in store '{}' during import of '{}'", (Object)storeName, (Object)publicProjectId);
        ExternalUploadIndexRepairer.repair(externalUploadStoreValidationResult, new CompressingStore(migratedStore), (IStorageSystem)existingUpToDateProjectStorageSystem, this.parameters.getIndexLayer(), internalProjectId, projectExists, storeName, ProjectStoreImporter.getUploadIndexClass(storeName), this.cancelable, projectImportProgress::setStatusMessage, (IFactory<IStore, StorageException>)this.storeFactory);
    }

    private void importStoreWithMigration(ZipArchiveEntry entry, InternalProjectId internalProjectId, String storeName, IStorageSystem temporaryStorageSystem) throws StorageException, IOException, ExecutionCanceledException {
        StorageMigrator migrator = new StorageMigrator(this.sourceVersion, (IFactory)this.storeFactory);
        IStore migratingImportStore = migrator.decorate((IStorageSystemProvider)new SingleStorageSystemProvider(temporaryStorageSystem), this.transactionalMigrationIndexLayer.getStorageCacheProvider()).openProjectStorageSystem(internalProjectId).openStore(storeName);
        this.storeImporter.importStore(entry, migratingImportStore, this.cancelable);
        migrator.flushBatchMigrationsForOpenStorageSystems();
    }

    private static boolean isExternalUploadStore(String storeName) {
        return UPLOAD_STORES.containsKey(storeName);
    }

    private static <COMMIT extends Serializable> Class<? extends ExternalUploadIndexBase<COMMIT>> getUploadIndexClass(String storeName) {
        return UPLOAD_STORES.get(storeName);
    }

    private static boolean isStoreIgnoredForIncrementalUpdate(String storeName) {
        return storeName.endsWith("git-repository-infos");
    }

    private static Optional<Pair<PublicProjectId, String>> getProjectAndStoreName(ZipArchiveEntry entry) throws StorageException {
        String entryName = entry.getName();
        if (!ProjectStoreImporter.isProjectEntry(entry) || entryName.endsWith("/Project-Config")) {
            return Optional.empty();
        }
        return Optional.of(ProjectStoreImporter.parseProjectAndStoreName(entryName));
    }

    public static boolean isProjectEntry(ZipArchiveEntry entry) {
        if (entry.isDirectory()) {
            return false;
        }
        String entryName = entry.getName();
        return entryName.contains("/") && !BackupUtils.isGlobalDataPath(entryName) && !FileSystemUtils.isSystemFileName((String)entryName) && !entryName.startsWith("custom-external-findings") && !entryName.startsWith("custom-external-metrics");
    }

    public static Pair<PublicProjectId, String> parseProjectAndStoreName(String entryName) throws StorageException {
        String[] parts = entryName.split("/");
        if (parts.length != 2) {
            throw new StorageException("Expected 2 parts in path of project store in backup: " + entryName);
        }
        return new Pair((Object)new PublicProjectId(parts[0]), (Object)parts[1]);
    }

    static {
        UPLOAD_STORES.put("element-review-uploads", ElementReviewUploadIndex.class);
        UPLOAD_STORES.put("external-analysis-results", ExternalAnalysisResultIndex.class);
        UPLOAD_STORES.put("finding-blacklist-staging", FindingBlacklistStagingIndex.class);
        UPLOAD_STORES.put("external-architecture-uploads", ExternalArchitectureUploadIndex.class);
    }
}

