/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.blacklisting;

import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.index.IMountableStorageIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

@Index(name="x-finding-blacklist", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED, EStorageOption.BACKUP, EStorageOption.CROSS_PROJECT_MOUNTABLE}, valueClasses={FindingBlacklistInfo.class})
public class BranchAgnosticFindingBlacklistIndex
extends IndexBase
implements IProjectIndex,
IMountableStorageIndex {
    public static final String INDEX_NAME = "x-finding-blacklist";

    public BranchAgnosticFindingBlacklistIndex(IStore store) {
        super(store);
    }

    public void setIfNewer(PairList<String, FindingBlacklistInfo> infos) throws StorageException {
        UnmodifiableList findingIds = infos.getFirstList();
        List<FindingBlacklistInfo> existingInfos = this.getExistingBlacklistInfos((List<String>)findingIds);
        PairList values = new PairList();
        for (int i = 0; i < findingIds.size(); ++i) {
            FindingBlacklistInfo existingInfo = existingInfos.get(i);
            FindingBlacklistInfo blacklistInfo = (FindingBlacklistInfo)infos.getSecond(i);
            if (existingInfo != null && existingInfo.getTimestamp() >= blacklistInfo.getTimestamp()) continue;
            values.add((Object)blacklistInfo.getFindingId(), (Object)StorageUtils.serialize((Serializable)blacklistInfo));
        }
        this.store.putWithStrings(values);
    }

    public void removeIfNewer(PairList<String, Long> infos) throws StorageException {
        List<FindingBlacklistInfo> existingInfos = this.getExistingBlacklistInfos((List<String>)infos.getFirstList());
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (int i = 0; i < existingInfos.size(); ++i) {
            FindingBlacklistInfo existingInfo = existingInfos.get(i);
            Long blacklistInfoTimestamp = (Long)infos.getSecond(i);
            if (existingInfo != null && existingInfo.getTimestamp() >= blacklistInfoTimestamp) continue;
            keysToDelete.add((String)infos.getFirst(i));
        }
        this.store.removeWithStrings(keysToDelete);
    }

    public List<@Nullable FindingBlacklistInfo> getExistingBlacklistInfos(List<String> findingIds) throws StorageException {
        return StorageUtils.deserializeValues((List)this.store.getWithStrings(findingIds));
    }

    public List<FindingBlacklistInfo> getAllExistingBlacklistInfos() throws StorageException {
        return StorageUtils.deserializeValues((List)this.store.getEntriesStartingWith("").getSecondList());
    }

    public Lock obtainStoreLock(String suffix) {
        return this.store.obtainLock(suffix);
    }
}

