/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.KeysOnlyIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="check-phase-dependencies", options={EStorageOption.BRANCHED})
public class CheckPhaseResultDependencyIndex
implements IProjectIndex {
    public static final String NAME = "check-phase-dependencies";
    private static final String SEPARATOR = "#-#";
    private static final String PHASE_KEYWORD_FILE_PREFIX = "p";
    private static final String FILE_PHASE_KEYWORD_PREFIX = "f";
    private static final String UNIFORM_PATH_KEYWORD_MARKER = "u";
    private static final String VALUE_KEYWORD_MARKER = "v";
    private final KeysOnlyIndex delegate;

    public CheckPhaseResultDependencyIndex(IStore store) {
        this.delegate = new KeysOnlyIndex(store);
    }

    public void updateDependencies(String uniformPath, Map<Class<? extends IGlobalExtractionPhase<?, ?>>, Set<String>> accessedUniformPaths, Map<Class<? extends IGlobalExtractionPhase<?, ?>>, Set<String>> accessedValues) throws StorageException {
        HashSet<String> keysToWrite = new HashSet<String>();
        CheckPhaseResultDependencyIndex.createKeys(uniformPath, UNIFORM_PATH_KEYWORD_MARKER, accessedUniformPaths, keysToWrite);
        CheckPhaseResultDependencyIndex.createKeys(uniformPath, VALUE_KEYWORD_MARKER, accessedValues, keysToWrite);
        Set<String> existingKeys = this.getKeysOfFile(uniformPath);
        HashSet keysToDelete = CollectionUtils.differenceSet(existingKeys, (Collection[])new Collection[]{keysToWrite});
        if (!keysToDelete.isEmpty()) {
            this.delegate.removeKeys(new ArrayList(keysToDelete));
        }
        keysToWrite.removeAll(existingKeys);
        this.delegate.storeKeys(new ArrayList<String>(keysToWrite));
    }

    private Set<String> getKeysOfFile(String uniformPath) throws StorageException {
        Set<String> existingKeys = this.delegate.streamKeysStartingWith(FILE_PHASE_KEYWORD_PREFIX + uniformPath + SEPARATOR).collect(Collectors.toSet());
        existingKeys.addAll(CheckPhaseResultDependencyIndex.invertKeys(existingKeys));
        return existingKeys;
    }

    private static List<String> invertKeys(Collection<String> keys) {
        return CollectionUtils.map(keys, CheckPhaseResultDependencyIndex::invertKey);
    }

    private static String invertKey(String filePhaseKeywordKey) {
        String[] fileAndPhaseKeyword = StringUtils.splitByWholeSeparator((String)filePhaseKeywordKey.substring(1), (String)SEPARATOR, (int)2);
        return PHASE_KEYWORD_FILE_PREFIX + fileAndPhaseKeyword[1] + SEPARATOR + fileAndPhaseKeyword[0];
    }

    private static void createKeys(String uniformPath, String marker, Map<Class<? extends IGlobalExtractionPhase<?, ?>>, Set<String>> keywordsByPhase, Set<String> result) {
        for (Map.Entry<Class<IGlobalExtractionPhase<?, ?>>, Set<String>> entry : keywordsByPhase.entrySet()) {
            String phase = entry.getKey().getName();
            for (String keyword : entry.getValue()) {
                result.add(PHASE_KEYWORD_FILE_PREFIX + phase + SEPARATOR + marker + keyword + SEPARATOR + uniformPath);
                result.add(FILE_PHASE_KEYWORD_PREFIX + uniformPath + SEPARATOR + phase + SEPARATOR + marker + keyword);
            }
        }
    }

    public Set<String> getPathsForAccessedValues(String phaseName, Set<String> accessedValues) throws StorageException {
        return this.getPathsForAccessedKeywords(phaseName, accessedValues, VALUE_KEYWORD_MARKER);
    }

    public Set<String> getPathsForAccessedUniformPaths(String phaseName, Set<String> accessedPaths) throws StorageException {
        return this.getPathsForAccessedKeywords(phaseName, accessedPaths, UNIFORM_PATH_KEYWORD_MARKER);
    }

    private Set<String> getPathsForAccessedKeywords(String phaseName, Set<String> accessedKeywords, String marker) throws StorageException {
        if (accessedKeywords.size() < 50) {
            HashSet<String> result = new HashSet<String>();
            for (String keyword : accessedKeywords) {
                String prefix = PHASE_KEYWORD_FILE_PREFIX + phaseName + SEPARATOR + marker + keyword + SEPARATOR;
                result.addAll(this.delegate.streamKeysStartingWith(prefix).map(key -> StringUtils.stripPrefix((String)key, (String)prefix)).collect(Collectors.toSet()));
            }
            return result;
        }
        String prefix = PHASE_KEYWORD_FILE_PREFIX + phaseName + SEPARATOR + marker;
        return this.delegate.streamKeysStartingWith(prefix).map(key -> StringUtils.stripPrefix((String)key, (String)prefix)).map(key -> key.split(SEPARATOR, 2)).filter(keywordAndPath -> accessedKeywords.contains(keywordAndPath[0])).map(keywordAndPath -> keywordAndPath[1]).collect(Collectors.toSet());
    }

    public void removeDependenciesOfFiles(List<String> uniformPaths) throws StorageException {
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (String uniformPath : uniformPaths) {
            keysToDelete.addAll(this.getKeysOfFile(uniformPath));
        }
        if (!keysToDelete.isEmpty()) {
            this.delegate.removeKeys(keysToDelete);
        }
    }
}

