/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.index.code_change.ChangeRegion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ChangeRegions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long creationTimestamp;
    private final List<ChangeRegion> regions = new ArrayList<ChangeRegion>();

    public ChangeRegions(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public List<ChangeRegion> getRegions() {
        return this.regions;
    }

    public void sortRegions() {
        Collections.sort(this.regions);
    }

    public void replaceRegion(ChangeRegion newRegion) {
        this.regions.set(this.findRegionIndex((SimpleRegion)newRegion), newRegion);
    }

    private int findRegionIndex(SimpleRegion newRegion) throws AssertionError {
        int index = Collections.binarySearch(this.regions, newRegion);
        CCSMAssert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Region must be contained in list!");
        CCSMAssert.isTrue((this.regions.get(index).getEnd() == newRegion.getEnd() ? 1 : 0) != 0, (String)"Region end values must be same!");
        return index;
    }

    public ChangeRegion findRegion(SimpleRegion region) {
        return this.regions.get(this.findRegionIndex(region));
    }

    public long getMaximalTimestamp(int start, int end) {
        long result = 0L;
        int index = Collections.binarySearch(this.regions, new SimpleRegion(start, end));
        if (index < 0) {
            index = Math.max(0, -index - 2);
        }
        if (index < this.regions.size() && this.regions.get(index).getEnd() < start) {
            ++index;
        }
        while (index < this.regions.size() && this.regions.get(index).getStart() <= end) {
            result = Math.max(result, this.regions.get(index).getLastChangeTimestamp());
            ++index;
        }
        return result;
    }
}

