/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.core;

import com.teamscale.index.code_clones.core.Unit;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class TokenUnit
extends Unit {
    public static final Set<ETokenType> TYPE_KEYWORDS = EnumSet.copyOf(Arrays.asList(ETokenType.STRING, ETokenType.BOOL, ETokenType.BOOLEAN, ETokenType.DECIMAL, ETokenType.DOUBLE, ETokenType.FLOAT, ETokenType.SINGLE, ETokenType.CHAR, ETokenType.BYTE, ETokenType.OBJECT, ETokenType.INT, ETokenType.VAR));
    private final ETokenType tokenType;

    public TokenUnit(String content, String unnormalizedContent, int filteredStartOffset, int filteredEndOffset, String elementUniformPath, ETokenType tokenType, int indexInElement) {
        super(filteredStartOffset, filteredEndOffset, elementUniformPath, content, unnormalizedContent, indexInElement);
        this.tokenType = tokenType;
    }

    public TokenUnit(String content, int filteredStartOffset, int filteredEndOffset, String elementUniformPath, ETokenType tokenType, int indexInElement) {
        this(content, content, filteredStartOffset, filteredEndOffset, elementUniformPath, tokenType, indexInElement);
    }

    @Override
    public String toString() {
        String result = "TOKEN '" + this.getContent() + "' (" + String.valueOf(this.getType()) + ")";
        result = result + " \"" + this.getElementUniformPath() + "\" f-offset " + this.getFilteredStartOffset();
        return result;
    }

    public ETokenType getType() {
        return this.tokenType;
    }

    public static boolean couldBeNormalized(ETokenType tokenType) {
        ETokenType.ETokenClass tokenClass = tokenType.getTokenClass();
        return tokenClass == ETokenType.ETokenClass.IDENTIFIER || tokenClass == ETokenType.ETokenClass.LITERAL || TYPE_KEYWORDS.contains(tokenType);
    }
}

