/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.detection;

import com.google.common.base.Preconditions;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.SuffixTreeChunkWrapper;
import com.teamscale.index.code_clones.report.ICloneClassReporter;
import com.teamscale.index.code_clones.suffixtree.CloneDetectingSuffixTree;
import com.teamscale.index.code_clones.suffixtree.ICloneReporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

public class CloneIndexCloneSearcher
implements ICloneReporter {
    private final int chunkLength;
    private final Set<String> originIds;
    private final ICloneClassReporter reporter;
    private final int minLength;
    private final List<SuffixTreeChunkWrapper> chunkString;
    private CloneClass cloneClass;
    private boolean hadOriginIdDuringCloneClassConstruction = false;

    public CloneIndexCloneSearcher(@NonNull Set<String> originIds, @NonNull ICloneClassReporter reporter, int minLength, @NonNull List<CloneChunk> chunks, int chunkLength) {
        Preconditions.checkArgument((minLength >= chunkLength ? 1 : 0) != 0, (Object)"Minimum clone length cannot be shorter than chunk length.");
        this.originIds = originIds;
        this.reporter = reporter;
        this.minLength = minLength;
        this.chunkLength = chunkLength;
        this.chunkString = new ArrayList<SuffixTreeChunkWrapper>(chunks.size() + originIds.size());
        this.fillChunkString(chunks);
    }

    private void fillChunkString(@NonNull List<CloneChunk> chunks) {
        CloneChunk previous = null;
        for (CloneChunk chunk : CollectionUtils.sort(chunks, CloneChunk.CHUNK_COMPARATOR)) {
            if (previous != null && !CloneIndexCloneSearcher.isConsecutive(previous, chunk)) {
                this.chunkString.add(SuffixTreeChunkWrapper.createSentinel());
            }
            this.chunkString.add(new SuffixTreeChunkWrapper(chunk));
            previous = chunk;
        }
        this.chunkString.add(SuffixTreeChunkWrapper.createSentinel());
    }

    private static boolean isConsecutive(@NonNull CloneChunk previous, @NonNull CloneChunk chunk) {
        if (!previous.getOriginId().equals(chunk.getOriginId())) {
            return false;
        }
        return previous.getFirstUnitIndex() + 1 == chunk.getFirstUnitIndex();
    }

    public void reportClones() throws StorageException {
        new CloneDetectingSuffixTree(this.chunkString).findClones(this.minLength - this.chunkLength + 1, this);
    }

    void reportClonesWithExternalReporter(ICloneReporter externalReporter) throws StorageException {
        new CloneDetectingSuffixTree(this.chunkString).findClones(this.minLength - this.chunkLength + 1, externalReporter);
    }

    @Override
    public boolean startCloneClass(int normalizedLength, int numberOfClones) {
        int cloneLength = normalizedLength + this.chunkLength - 1;
        if (!this.reporter.shouldReport(cloneLength, numberOfClones)) {
            return false;
        }
        this.cloneClass = new CloneClass(cloneLength);
        this.hadOriginIdDuringCloneClassConstruction = false;
        return true;
    }

    @Override
    public @NonNull Clone addClone(int startPosition, int length) {
        CloneChunk headChunk = this.chunkString.get(startPosition).getChunk();
        CloneChunk tailChunk = this.chunkString.get(startPosition + length - 1).getChunk();
        this.hadOriginIdDuringCloneClassConstruction = this.hadOriginIdDuringCloneClassConstruction || this.originIds.contains(headChunk.getOriginId());
        TextRegionLocation location = new TextRegionLocation(headChunk.getOriginId(), headChunk.getRawStartOffset(), tailChunk.getRawEndOffset() - 1, headChunk.getFirstRawLineNumber(), tailChunk.getLastRawLineNumber() - 1);
        return new Clone(this.cloneClass, location, headChunk.getFirstUnitIndex(), length + this.chunkLength - 1);
    }

    @Override
    public boolean completeCloneClass() throws StorageException {
        if (!this.hadOriginIdDuringCloneClassConstruction) {
            return false;
        }
        this.reporter.report(this.cloneClass);
        return true;
    }
}

