/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import com.teamscale.index.code_clones.core.SentinelUnit;
import com.teamscale.index.code_clones.core.Unit;
import com.teamscale.index.code_clones.normalization.RepetitionDetector;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.region.RegionSet;

public class RepetitionRemover {
    private static final RepetitionDetector REPETITION_DETECTOR = new RepetitionDetector(2, 20);

    public static List<Unit> removeRepetitions(List<Unit> units) {
        RegionSet removedRegions = REPETITION_DETECTOR.detectRepetitions(units);
        if (removedRegions != null && !removedRegions.isEmpty()) {
            return RepetitionRemover.applyRemovals(units, removedRegions.createCompact());
        }
        return units;
    }

    private static List<Unit> applyRemovals(List<Unit> units, RegionSet removed) {
        ArrayList<Unit> result = new ArrayList<Unit>();
        boolean inRemoval = false;
        for (int i = 0; i < units.size(); ++i) {
            Unit unit = units.get(i);
            int newIndex = result.size();
            unit.setIndexInElement(newIndex);
            if (inRemoval) {
                if (removed.contains(i)) continue;
                inRemoval = false;
                result.add(unit);
                continue;
            }
            if (removed.contains(i)) {
                inRemoval = true;
                result.add(new SentinelUnit(unit));
                continue;
            }
            result.add(unit);
        }
        return result;
    }
}

