/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.report;

import com.teamscale.index.code_clones.report.CollectingCloneClassReporter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SizeFilteringCollectingCloneClassReporter
extends CollectingCloneClassReporter {
    private final int cloneClassSizeLimit;
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean loggedWarning = false;

    public SizeFilteringCollectingCloneClassReporter(int cloneClassSizeLimit) {
        this.cloneClassSizeLimit = cloneClassSizeLimit;
    }

    @Override
    public boolean shouldReport(int normalizedLength, int numberOfClones) {
        if (numberOfClones > this.cloneClassSizeLimit) {
            if (!this.loggedWarning) {
                this.loggedWarning = true;
                LOGGER.warn("Ignored very frequent clone with " + numberOfClones + " instances, exceeding the current limit of " + this.cloneClassSizeLimit + " configured in the analysis profile. This is only logged for the first clone exceeding the limit.");
            }
            return false;
        }
        return true;
    }
}

