/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.google.common.base.Suppliers;
import com.teamscale.index.comment_analysis.CommentCompletenessAnalyzerBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.function.Supplier;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class CommentCompletenessFindingsAnalyzer
extends CommentCompletenessAnalyzerBase {
    public static final String FINDING_GROUP_NAME = "Missing Interface Comment";
    private final ListMap<String, IndexFinding> findings = new ListMap();
    private Supplier<LineOffsetConverter> lineOffsetConverter;
    public static final String ENTITY_TYPE_PROPERTY_NAME = "Entity";

    public CommentCompletenessFindingsAnalyzer(boolean requireDocComment, String entitySelectionExpression, boolean allowCommentInside) {
        super(requireDocComment, entitySelectionExpression, allowCommentInside);
    }

    @Override
    protected void analyzeTokens(List<IToken> tokens, TokenElementInfo element) throws StorageException {
        this.lineOffsetConverter = Suppliers.memoize(() -> new LineOffsetConverter(element.getText()));
        super.analyzeTokens(tokens, element);
    }

    @Override
    protected void analyzeSelectedEntity(ShallowEntity entity, TokenElementInfo element, CommentCompletenessAnalyzerBase.ECommentInspectionResult commentType) {
        int endOffset;
        if (commentType == CommentCompletenessAnalyzerBase.ECommentInspectionResult.COMMENTED) {
            return;
        }
        IToken lastEntity = (IToken)CollectionUtils.getLast((List)entity.ownStartTokens());
        if (lastEntity == null) {
            return;
        }
        int startOffset = entity.getStartOffset();
        if (startOffset < (endOffset = lastEntity.getEndOffset())) {
            IndexFinding finding = new IndexFinding(FINDING_GROUP_NAME, "Comments", CommentCompletenessFindingsAnalyzer.getFindingsMessage(entity, commentType == CommentCompletenessAnalyzerBase.ECommentInspectionResult.EMPTY), (ElementLocation)new TextRegionLocation(element.getUniformPath(), startOffset, endOffset, this.lineOffsetConverter.get().getLine(startOffset), this.lineOffsetConverter.get().getLine(endOffset)));
            finding.setProperty(ENTITY_TYPE_PROPERTY_NAME, (Object)entity.getType().getReadableName());
            this.findings.add((Object)element.getUniformPath(), (Object)finding);
        }
    }

    private static String getFindingsMessage(ShallowEntity entity, boolean isEmptyComment) {
        if (StringUtils.isEmpty((String)entity.getName())) {
            if (isEmptyComment) {
                return "Empty interface comment";
            }
            return "Interface comment missing";
        }
        if (isEmptyComment) {
            return "Empty interface comment for `%s`".formatted(entity.getName());
        }
        return "Interface comment missing for `%s`".formatted(entity.getName());
    }

    public ListMap<String, IndexFinding> getFindings() {
        return this.findings;
    }
}

