/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentCompletenessAnalyzerBase;
import com.teamscale.index.comment_analysis.CommentFindingAnalysisBase;
import com.teamscale.index.comment_analysis.ECommentCategory;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class CommentedOutCodeAnalysis
extends CommentFindingAnalysisBase {
    public static final String FINDING_GROUP_NAME = "Commented Out Code";
    private static final String COUNT_COMMENTED_LINES_OF_CODE = "LOC";
    private static final String GWT_NATIVE_CODE_START = "/*-{";
    private static final String GWT_NATIVE_CODE_END = "}-*/";
    private static final String EDITOR_FOLD_OPEN_CODE_START = "<editor-fold";
    private static final String EDITOR_FOLD_OPEN_CODE_END = ">";
    private static final String EDITOR_FOLD_CLOSE_CODE = "</editor-fold>";
    private static final Pattern DOXYGEN_PATTERN = Pattern.compile("@.|\\.");
    private static final Pattern STRING_LITERAL_PATTERN = Pattern.compile("(([\"']).*\\2\\w*\\+\\w*)*(([\"']).*\\4)", 32);

    public CommentedOutCodeAnalysis() {
        super(FINDING_GROUP_NAME);
    }

    @Override
    protected void analyzeComment(Comment comment, ECommentCategory category) {
        if (category != ECommentCategory.CODE) {
            return;
        }
        if (CommentedOutCodeAnalysis.isEndOfLineCommentAfterStatement(comment)) {
            return;
        }
        if (comment.getLanguage() == ELanguage.JAVA && (CommentedOutCodeAnalysis.isGwtNativeCode(comment) || CommentedOutCodeAnalysis.isEditorFold(comment))) {
            return;
        }
        if (comment.getLanguage() == ELanguage.CS && CommentCompletenessAnalyzerBase.isInheritdocFoundInCSComment(comment.getText())) {
            return;
        }
        if (LanguageGroups.C_AND_DERIVATIVES.contains(comment.getLanguage()) && CommentedOutCodeAnalysis.isDoxygen(comment)) {
            return;
        }
        IndexFinding finding = this.createFindingForComment(comment, FINDING_GROUP_NAME);
        TextRegionLocation location = (TextRegionLocation)CCSMAssert.checkedCast((Object)finding.getLocation(), TextRegionLocation.class);
        int loc = 1 + location.getRawEndLine() - location.getRawStartLine();
        finding.setProperty(COUNT_COMMENTED_LINES_OF_CODE, (Object)loc);
    }

    private static boolean isEndOfLineCommentAfterStatement(Comment comment) {
        return comment.getToken().getType() == ETokenType.END_OF_LINE_COMMENT && StringUtils.countLines((String)comment.getText()) == 1 && comment.getTokenIndex() > 0 && ((IToken)comment.getTokens().get(comment.getTokenIndex() - 1)).getLineNumber() == comment.getToken().getLineNumber();
    }

    private static boolean isGwtNativeCode(Comment comment) {
        String commentText = comment.getRawCommentText().trim();
        return commentText.startsWith(GWT_NATIVE_CODE_START) && commentText.endsWith(GWT_NATIVE_CODE_END);
    }

    private static boolean isEditorFold(Comment comment) {
        String commentText = comment.getText();
        boolean isEditorCodeFoldingBegin = commentText.startsWith(EDITOR_FOLD_OPEN_CODE_START) && commentText.endsWith(EDITOR_FOLD_OPEN_CODE_END);
        boolean isEditorCodeFoldingClosing = commentText.equals(EDITOR_FOLD_CLOSE_CODE);
        return isEditorCodeFoldingBegin || isEditorCodeFoldingClosing;
    }

    @VisibleForTesting
    static String removeStringLiterals(String commentText) {
        return STRING_LITERAL_PATTERN.matcher(commentText).replaceAll("");
    }

    private static boolean isDoxygen(Comment comment) {
        String commentText = comment.getText();
        return DOXYGEN_PATTERN.matcher(CommentedOutCodeAnalysis.removeStringLiterals(commentText)).find();
    }
}

