/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentFindingAnalysisBase;
import com.teamscale.index.comment_analysis.ECommentCategory;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.LineSplitter;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class ExclamationQuestionMarkAnalysis
extends CommentFindingAnalysisBase {
    public static final String FINDING_GROUP_NAME = "Exclamation or Question Mark in Comment";
    private static final String[] FORBIDDEN_CHARACTERS = new String[]{"!", "?"};
    private static final Pattern EXCLUDE_PATTERN = Pattern.compile("(['\"].*?([?!]).*?['\"])|://.*? |!=+|<code>.*?</code>|\\{@code.*?}", 32);
    private static final Set<ECommentCategory> SUPPORTED_CATEGORIES = EnumSet.of(ECommentCategory.INLINE, ECommentCategory.INTERFACE, ECommentCategory.HEADER);

    public ExclamationQuestionMarkAnalysis() {
        super(FINDING_GROUP_NAME);
    }

    @Override
    protected void analyzeComment(Comment comment, ECommentCategory category) {
        if (SUPPORTED_CATEGORIES.contains((Object)category)) {
            this.analyzeComment(comment);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void analyzeComment(Comment comment) {
        String commentString = comment.getRawCommentText();
        if (!StringUtils.containsOneOf((String)commentString, (String[])FORBIDDEN_CHARACTERS)) {
            return;
        }
        String modifiedCommentString = this.replaceExclamationAndQuestionMarksInExcludePatterns(commentString);
        LineSplitter lineSplitter = new LineSplitter(modifiedCommentString);
        int i = 0;
        while (lineSplitter.hasNext()) {
            @Nullable Pair match = StringUtils.indexOfAndFirstMatch((String)lineSplitter.next(), (String[])FORBIDDEN_CHARACTERS);
            if ((Integer)match.getFirst() > -1) {
                this.createFindingForComment(comment, FINDING_GROUP_NAME, i);
            }
            ++i;
        }
    }

    private String replaceExclamationAndQuestionMarksInExcludePatterns(String string) {
        Matcher matcher = EXCLUDE_PATTERN.matcher((CharSequence)string);
        if (matcher.find()) {
            String escapedForbiddenCharacters = "[" + Arrays.stream(FORBIDDEN_CHARACTERS).map(Pattern::quote).collect(Collectors.joining("|")) + "]";
            int start = matcher.start();
            int end = matcher.end();
            string = ((String)string).substring(0, start) + ((String)string).substring(start, end).replaceAll(escapedForbiddenCharacters, "*") + this.replaceExclamationAndQuestionMarksInExcludePatterns(((String)string).substring(end));
        }
        return string;
    }
}

