/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocationUtils;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class SourceCodeSearchFindingAnalyzer {
    private static final int MAX_FINDING_MESSAGE_LENGTH = 300;
    private final PatternList patternList;
    private final PatternList exclusionPatternList;
    private final EnumSet<ETokenType.ETokenClass> tokenClasses = EnumSet.noneOf(ETokenType.ETokenClass.class);
    private final EnumSet<ETokenType> tokenTypes = EnumSet.noneOf(ETokenType.class);
    private final Function<TokenElementInfo, IPreprocessor> preprocessorFactory;
    private final String findingCategoryName;
    private final String findingGroupName;
    private final String messagePrefix;
    private final ListMap<String, IndexFinding> findings = new ListMap();

    public void addTokenClass(ETokenType.ETokenClass tokenClass) {
        this.tokenClasses.add(tokenClass);
    }

    public SourceCodeSearchFindingAnalyzer(Function<TokenElementInfo, IPreprocessor> preprocessorFactory, PatternList patternList, PatternList exclusionPatternList, String findingGroupName, String findingCategoryName, String messagePrefix) {
        this.preprocessorFactory = preprocessorFactory;
        this.patternList = patternList;
        this.exclusionPatternList = exclusionPatternList;
        this.findingCategoryName = findingCategoryName;
        this.findingGroupName = findingGroupName;
        this.messagePrefix = messagePrefix;
    }

    private void analyzeToken(String uniformPath, IToken token, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        Supplier isExcluded = Suppliers.memoize(() -> this.exclusionPatternList.findsAnyIn(token.getText()));
        for (Pattern pattern : this.patternList) {
            Matcher matcher = pattern.matcher(token.getText());
            while (matcher.find()) {
                if (((Boolean)isExcluded.get()).booleanValue()) {
                    return;
                }
                String match = matcher.group();
                int startOffset = token.getOffset() + matcher.start();
                Object message = SourceCodeSearchFindingAnalyzer.getSanitizedMessage(match);
                if (!StringUtils.isEmpty((String)this.messagePrefix)) {
                    message = this.messagePrefix.trim() + " " + match;
                }
                int endOffset = startOffset + match.length() - 1;
                IndexFinding finding = new IndexFinding(this.findingGroupName, this.findingCategoryName, (String)message, (ElementLocation)TextRegionLocationUtils.createTextRegionLocationForFilteredOffsets((String)uniformPath, (int)startOffset, (int)endOffset, (StringOffsetTransformer)offsetTransformer, (LineOffsetConverter)rawLineOffsetConverter));
                this.findings.add((Object)uniformPath, (Object)finding);
            }
        }
    }

    private static String getSanitizedMessage(String match) {
        String firstLine = StringUtils.getFirstLine((String)match);
        String sanitizedMessage = MarkupUtils.escapeMarkdownRelevantSymbols((String)firstLine);
        return StringUtils.truncateWithEllipsis((String)sanitizedMessage, (int)300);
    }

    public ListMap<String, IndexFinding> getFindings() {
        return this.findings;
    }

    public void process(Collection<TokenElementInfo> elements) {
        if (this.tokenClasses.isEmpty() && this.tokenTypes.isEmpty()) {
            throw new IllegalStateException("No token types or classes defined.");
        }
        for (TokenElementInfo element : elements) {
            String uniformPath = element.getUniformPath();
            StringOffsetTransformer offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
            LineOffsetConverter rawLineOffsetConverter = new LineOffsetConverter(element.getText());
            IPreprocessor preprocessor = this.preprocessorFactory.apply(element);
            List tokens = CollectionUtils.filter(element.getTokens(), token -> !token.getType().isSynthetic());
            for (IToken token2 : preprocessor.preprocess(uniformPath, tokens)) {
                if (!this.isIncludedToken(token2)) continue;
                this.analyzeToken(uniformPath, token2, offsetTransformer, rawLineOffsetConverter);
            }
        }
    }

    private boolean isIncludedToken(IToken token) {
        return this.tokenClasses.contains(token.getType().getTokenClass()) || this.tokenTypes.contains(token.getType());
    }

    public static class MultilineTokenCombiner
    implements IPreprocessor {
        private final LineOffsetConverter lineOffsetConverter;
        private final Set<ETokenType> tokenTypesToCombine;

        public MultilineTokenCombiner(TokenElementInfo tokenElementInfo, Set<ETokenType> tokenTypesToCombine) {
            this.lineOffsetConverter = new LineOffsetConverter(tokenElementInfo.getText());
            this.tokenTypesToCombine = EnumSet.copyOf(tokenTypesToCombine);
        }

        public List<IToken> preprocess(String uniformPath, List<IToken> tokens) {
            ArrayList<IToken> result = new ArrayList<IToken>(tokens.size());
            for (IToken currentToken : tokens) {
                if (result.isEmpty()) {
                    result.add(currentToken);
                    continue;
                }
                IToken lastToken = (IToken)result.get(result.size() - 1);
                if (this.shouldBeMerged(lastToken, currentToken)) {
                    IToken replacement = lastToken.newToken(lastToken.getType(), lastToken.getOffset(), lastToken.getLineNumber(), MultilineTokenCombiner.getCombinedText(currentToken, lastToken), lastToken.getOriginId());
                    CCSMAssert.isTrue((currentToken.getEndOffset() == replacement.getEndOffset() && lastToken.getOffset() == replacement.getOffset() ? 1 : 0) != 0, () -> "Calculated incorrect replacement token %s for last %s and current %s".formatted(replacement, lastToken, currentToken));
                    result.set(result.size() - 1, replacement);
                    continue;
                }
                result.add(currentToken);
            }
            return result;
        }

        private static String getCombinedText(IToken currentToken, IToken lastToken) {
            int additionalSpacing = currentToken.getOffset() - (lastToken.getEndOffset() + 1) - "\n".length();
            return lastToken.getText() + "\n" + " ".repeat(additionalSpacing) + currentToken.getText();
        }

        private boolean shouldBeMerged(IToken lastToken, IToken currentToken) {
            return this.isOnNextLine(lastToken, currentToken) && MultilineTokenCombiner.areOfSameType(lastToken, currentToken) && this.isTypeToCombine(currentToken.getType());
        }

        private boolean isOnNextLine(IToken lastToken, IToken currentToken) {
            int lastTokenEndLine = this.lineOffsetConverter.getLine(lastToken.getEndOffset());
            return lastTokenEndLine == currentToken.getLineNumber();
        }

        private static boolean areOfSameType(IToken lastToken, IToken currentToken) {
            return lastToken.getType() == currentToken.getType();
        }

        private boolean isTypeToCombine(ETokenType type) {
            return this.tokenTypesToCombine.contains(type);
        }
    }
}

