/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.classification;

import com.teamscale.index.comment_analysis.classification.CodeCharacteristicsChecker;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageProperties;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.ThreadLocalCache;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;

public class CodeRecognizer {
    private static final int MINIMUM_REPEATED_CHARACTERS = 4;
    private static final ICache<ImmutablePair<String, ELanguage>, Boolean, NeverThrownRuntimeException> CODE_LINE_CACHE = new ThreadLocalCache(null, pair -> CodeRecognizer.isCodeLineUncached((String)pair.getFirst(), (ELanguage)pair.getSecond()), ECachingStrategy.LRU.getBackend(10000));
    private static final Set<String> BRACES = CollectionUtils.asHashSet((Object[])new String[]{"{", "}"});
    private static final Pattern MARKUP_PATTERN = Pattern.compile("([@%\\\\][a-zA-Z]*|-e)[(\\[{]|\\{@|[@%\\\\](return|param)");
    private static final Pattern COMMON_MARKER_PATTERN = Pattern.compile("---");
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("</?\\w+.*/?>");
    private static final Pattern JAVA_CONTROL_LOOP_PATTERN = Pattern.compile("(if|while|for)\\s*\\(.*");
    private static final Pattern METHOD_CONSTRUCTOR_CALL_PATTERN = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*\\.|[^\\w\\s] new\\s+)[_a-zA-Z][_a-zA-Z0-9]*\\s*\\(.*?\\)|\\(&");
    private static final Pattern ASSIGNMENT_PATTERN = Pattern.compile(".*([_a-zA-Z0-9]+\\.)*[_a-zA-Z0-9]+\\s*.?=.*;\\s*");
    private static final Pattern JAVA_PACKAGE_IMPORT_PATTERN = Pattern.compile("(package|import(\\s+static)?)\\s*\\w+(\\.\\w+)+(\\.\\*)?;");

    public static boolean isCodeLine(String commentLine, ELanguage language) {
        return (Boolean)CODE_LINE_CACHE.obtain((Object)new ImmutablePair((Object)commentLine, (Object)language));
    }

    private static boolean isCodeLineUncached(String commentLine, ELanguage language) {
        if (CodeRecognizer.containsUrl(commentLine) || CodeRecognizer.containsMarkup(commentLine) || CodeRecognizer.containsTags(commentLine) || CodeRecognizer.containsCommonMarker(commentLine) || CodeRecognizer.containsRepeatedCharacter(commentLine)) {
            return false;
        }
        if (LanguageProperties.of((ELanguage)language).isCLike() && CodeRecognizer.isOnlyBrace(commentLine)) {
            return true;
        }
        switch (CodeCharacteristicsChecker.containsCodeCharacteristic(commentLine, language)) {
            case CODE: {
                return true;
            }
            case NO_CODE: {
                return false;
            }
        }
        if (LanguageProperties.of((ELanguage)language).isCLike() && (CodeRecognizer.containsJavaControlLoopPattern(commentLine) || CodeRecognizer.isAssignment(commentLine) || CodeRecognizer.matchMethodCallPattern(commentLine)) || CodeRecognizer.isPackageOrImportStatement(commentLine)) {
            return true;
        }
        return CodeRecognizer.hasEmptyBrackets(commentLine);
    }

    private static boolean containsRepeatedCharacter(String commentLine) {
        if (commentLine.length() < 4) {
            return false;
        }
        int repetitions = 1;
        char singleChar = '\u0000';
        for (int i = 0; i < commentLine.length(); ++i) {
            char c = commentLine.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c != singleChar) {
                singleChar = c;
                repetitions = 1;
            } else {
                ++repetitions;
            }
            if (repetitions != 4) continue;
            return true;
        }
        return false;
    }

    private static boolean isOnlyBrace(String commentLine) {
        return BRACES.contains(commentLine.trim());
    }

    private static boolean containsMarkup(String commentLine) {
        return MARKUP_PATTERN.matcher(commentLine).find();
    }

    private static boolean containsCommonMarker(String commentLine) {
        return COMMON_MARKER_PATTERN.matcher(commentLine).find();
    }

    private static boolean containsUrl(String commentLine) {
        return commentLine.contains("://");
    }

    private static boolean containsTags(String commentLine) {
        return HTML_TAG_PATTERN.matcher(commentLine).find();
    }

    private static boolean matchMethodCallPattern(String commentLine) {
        return METHOD_CONSTRUCTOR_CALL_PATTERN.matcher(commentLine).find();
    }

    private static boolean containsJavaControlLoopPattern(String commentLine) {
        return JAVA_CONTROL_LOOP_PATTERN.matcher(commentLine).find();
    }

    private static boolean isAssignment(String commentLine) {
        return ASSIGNMENT_PATTERN.matcher(commentLine).matches();
    }

    private static boolean hasEmptyBrackets(String commentLine) {
        int index = commentLine.indexOf("[]");
        return index > 0 && Character.isJavaIdentifierPart(commentLine.charAt(index - 1));
    }

    private static boolean isPackageOrImportStatement(String commentLine) {
        return JAVA_PACKAGE_IMPORT_PATTERN.matcher(commentLine).matches();
    }
}

