/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.identifier;

import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.German2Stemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public enum EStemmer {
    DANISH((SnowballProgram)new DanishStemmer()),
    DUTCH((SnowballProgram)new DutchStemmer()),
    ENGLISH((SnowballProgram)new EnglishStemmer()),
    FINNISH((SnowballProgram)new FinnishStemmer()),
    FRENCH((SnowballProgram)new FrenchStemmer()),
    GERMAN((SnowballProgram)new German2Stemmer()),
    HUNGARIAN((SnowballProgram)new HungarianStemmer()),
    ITALIAN((SnowballProgram)new ItalianStemmer()),
    NORWEGIAN((SnowballProgram)new NorwegianStemmer()),
    PORTUGUESE((SnowballProgram)new PortugueseStemmer()),
    ROMANIAN((SnowballProgram)new RomanianStemmer()),
    RUSSIAN((SnowballProgram)new RussianStemmer()),
    SPANISH((SnowballProgram)new SpanishStemmer()),
    SWEDISH((SnowballProgram)new SwedishStemmer()),
    TURKISH((SnowballProgram)new TurkishStemmer());

    private final SnowballProgram stemmer;

    private EStemmer(SnowballProgram stemmer) {
        this.stemmer = stemmer;
    }

    public synchronized String stem(String s) {
        this.stemmer.setCurrent(s);
        this.stemmer.stem();
        return this.stemmer.getCurrent();
    }
}

