/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.runtime.impl.analysis.CoreConfiguration;
import com.teamscale.index.issues.PathIssueIndex;
import com.teamscale.index.repository.ChangeMetricsSynchronizer;
import com.teamscale.index.repository.ContentPipelineRepositoryLogFileIndex;
import com.teamscale.index.repository.FindingIssuesMappingIndex;
import com.teamscale.index.repository.FirstCodeCommitIndex;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryCommitTaskMappingIndex;
import com.teamscale.index.repository.RepositoryCommitTaskMappingSynchronizer;
import com.teamscale.index.repository.RepositoryLogFileChurnIndex;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.base.RepositoryToTriggerMappingIndex;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.repository.history.ElementHistoryUpdater;
import com.teamscale.index.repository.history.match.name.PathByNameIndex;
import com.teamscale.index.repository.history.match.name.PathByNameIndexUpdater;
import com.teamscale.index.repository.status.ProjectConnectorStatusIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import java.util.Set;

public class RepositoryConfiguration
extends AnalysisConfigurationBase {
    public RepositoryConfiguration() {
        this.autoExpose();
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        RepositoryConfiguration.configureRepositoryIndexes(proxy);
        RepositoryConfiguration.createChangeMetrics(proxy.getCodeMetricSchema());
        RepositoryConfiguration.configureTriggers(proxy);
        RepositoryConfiguration.configureTimestampTaskMapping(proxy);
    }

    private static void configureRepositoryIndexes(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(TimestampAdjustmentIndex.class);
        proxy.createProjectIndex(FirstCodeCommitIndex.class);
        proxy.createProjectIndex(ProjectRepositoryChangeIndex.class);
        proxy.createProjectIndex(RepositoryLogIndex.class);
        proxy.createProjectIndex(RepositoryLogFileIndex.class);
        proxy.createProjectIndex(ContentPipelineRepositoryLogFileIndex.class);
        proxy.createProjectIndex(RepositoryLogFileChurnIndex.class);
        proxy.createProjectIndex(RepositoryCommitIssueMappingIndex.class);
        proxy.createProjectIndex(PathIssueIndex.class);
        proxy.createProjectIndex(FindingIssuesMappingIndex.class);
        proxy.createProjectIndex(RepositoryCommitTaskMappingIndex.class);
        proxy.createProjectIndex(RepositoryRevisionIndex.class);
        proxy.createProjectIndex(RepositoryToTriggerMappingIndex.class);
        proxy.createProjectIndex(ElementHistoryIndex.class);
        proxy.createProjectIndex(PathByNameIndex.class);
        proxy.createProjectIndex(ProjectConnectorStatusIndex.class);
    }

    private static void createChangeMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric("last-changed", schema.createMetricIndexSource("last-changed"), "Last Change Date", "Last Change Date", EMetricValueType.TIMESTAMP, MetricDirectorySchemaEntry.EAggregation.MAX, new EMetricProperty[0]);
        schema.addMetric("change-count", schema.createMetricIndexSource("change-count"), "Change Count", "The number of individual file changes", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.QUALITY_NEUTRAL});
    }

    private static void configureTriggers(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(PathByNameIndexUpdater.class, ETriggerConcurrency.OUTPUT_ISOLATED).setCost(ETriggerCost.CHEAP));
        proxy.createTrigger(new TriggerBuilder(ElementHistoryUpdater.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(ChangeMetricsSynchronizer.class).setCost(ETriggerCost.CHEAP));
    }

    private static void configureTimestampTaskMapping(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createTrigger(new TriggerBuilder(RepositoryCommitTaskMappingSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return List.of(CoreConfiguration.class);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) {
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

