/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.findings.metrics.FindingsCountForAllCategoriesMetric;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.configuration.CoreConfiguration;
import com.teamscale.index.configuration.WorkItemCoreConfiguration;
import com.teamscale.index.configuration.metrics.SpecItemFindingsDensityForSingleCategoryMetric;
import com.teamscale.index.metrics.MetricNames;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import java.util.Set;

public class WorkItemMetricsCoreConfiguration
extends AnalysisConfigurationBase {
    @ConfigExposed(name="Spec Item Findings Density", description="Enables metric for the spec item findings density for this quality indicator.")
    public boolean qualityIndicatorSpecItemFindingsDensityMetric = false;
    @ConfigExposed(name="Spec Item Findings Density (Red)", description="Enables metric for the red spec item findings density for this quality indicator.")
    public boolean qualityIndicatorSpecItemFindingsDensityRedMetric = false;
    @ConfigExposed(name="Spec Item Findings Density (Yellow)", description="Enables metric for the yellow spec item findings density for this quality indicator.")
    public boolean qualityIndicatorSpecItemFindingsDensityYellowMetric = false;

    public WorkItemMetricsCoreConfiguration() {
        this.autoExpose();
    }

    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return List.of(CoreConfiguration.class, WorkItemCoreConfiguration.class);
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorSpecItemFindingsDensityMetric"));
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorSpecItemFindingsDensityRedMetric"));
        template.registerQualityIndicatorOption(this.getOptionForField("qualityIndicatorSpecItemFindingsDensityYellowMetric"));
    }

    public void applyQualityIndicatorOptions(String qualityIndicatorName, ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.addFindingsDensityMetricsForCategory(qualityIndicatorName, proxy.getWorkItemMetricSchema());
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        WorkItemMetricsCoreConfiguration.configureMetricsSchema(proxy.getWorkItemMetricSchema());
    }

    private static void configureMetricsSchema(MetricSchemaProxy workItemMetricSchema) throws ProjectConfigurationException {
        workItemMetricSchema.addMetric("-spec-item-size-", workItemMetricSchema.createMetricIndexSource("-spec-item-size-"), "Spec Item Size", "Size of a spec item denoted by (roughly) the number of characters", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.SIZE_METRIC});
        MetricNames.SPEC_ITEM_FINDINGS_DENSITY.registerInSchema(workItemMetricSchema);
        MetricNames.SPEC_ITEM_FINDINGS_DENSITY_YELLOW.registerInSchema(workItemMetricSchema);
        MetricNames.SPEC_ITEM_FINDINGS_DENSITY_RED.registerInSchema(workItemMetricSchema);
    }

    private void addFindingsDensityMetricsForCategory(String category, MetricSchemaProxy schema) throws ProjectConfigurationException {
        if (this.qualityIndicatorSpecItemFindingsDensityMetric) {
            WorkItemMetricsCoreConfiguration.addFindingsDensityMetricForCategory(category, MetricNames.FINDINGS_COUNT_BY_CATEGORY, schema);
        }
        if (this.qualityIndicatorSpecItemFindingsDensityRedMetric) {
            WorkItemMetricsCoreConfiguration.addFindingsDensityMetricForCategory(category, MetricNames.FINDINGS_COUNT_BY_CATEGORY_RED, schema);
        }
        if (this.qualityIndicatorSpecItemFindingsDensityYellowMetric) {
            WorkItemMetricsCoreConfiguration.addFindingsDensityMetricForCategory(category, MetricNames.FINDINGS_COUNT_BY_CATEGORY_YELLOW, schema);
        }
    }

    private static void addFindingsDensityMetricForCategory(String category, FindingsCountForAllCategoriesMetric findingsCountByCategoryMetric, MetricSchemaProxy schema) throws ProjectConfigurationException {
        new SpecItemFindingsDensityForSingleCategoryMetric(findingsCountByCategoryMetric.createFindingsCountMetricForCategory(category, false)).registerInSchema(schema);
    }
}

