/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.migrations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.IJsonMigrator;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.index.configuration.AnalysisProfileMigrationUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class V211FixFaultyMigration204
implements IJsonMigrator {
    private static final String CHECK_ID = "cqse-compatible-declaration-shall-be-visible";
    private static final String CHECK_OPTION = "Excluded function names";
    private static final String ANALYSIS_GROUP_NAME = "Bad Practice";
    private static final EAnalysisProfileVersion FAULTY_MIGRATION = EAnalysisProfileVersion.ANALYSIS_PROFILE_VERSION_204;
    private final @Nullable AnalysisProfileVersionedIndex versionedIndex;

    public V211FixFaultyMigration204(GlobalStorageSystem globalStorageSystem) throws MigrationException {
        try {
            this.versionedIndex = (AnalysisProfileVersionedIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        }
        catch (StorageException e) {
            throw new MigrationException((Throwable)e);
        }
    }

    public @NonNull String migrate(@Language(value="JSON") String currentJson) throws MigrationException {
        if (this.versionedIndex == null) {
            return currentJson;
        }
        String analysisProfileName = AnalysisProfileMigrationUtils.getAnalysisProfileName(currentJson);
        try {
            AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory history = this.versionedIndex.getAnalysisProfileVersionHistory(analysisProfileName);
            if (history == null) {
                return currentJson;
            }
            AnalysisProfileVersionedIndex.AnalysisProfileEditVersion versionBeforeFaultyMigration = V211FixFaultyMigration204.findVersionBeforeFaultyMigration(history);
            if (versionBeforeFaultyMigration == null || !V211FixFaultyMigration204.isAffectedFromFaultyMigration(versionBeforeFaultyMigration) || !V211FixFaultyMigration204.checkCanBeRestored(currentJson)) {
                return currentJson;
            }
            PairList<String, String> originalOptions = V211FixFaultyMigration204.getOriginalOptionValues(versionBeforeFaultyMigration);
            if (V211FixFaultyMigration204.checkWasNotEnabledOrCorrectlyDisabledDuringMigration204(originalOptions) || V211FixFaultyMigration204.checkHasBeenChangedManuallyAfterFaultyMigration(currentJson)) {
                return currentJson;
            }
            return V211FixFaultyMigration204.restoreCheckEnablement(currentJson, originalOptions);
        }
        catch (JsonSerializationException | StorageException e) {
            throw new MigrationException(e);
        }
    }

    private static boolean checkWasNotEnabledOrCorrectlyDisabledDuringMigration204(PairList<String, String> originalOptions) {
        String checkEnablement = (String)originalOptions.getSecond(0);
        return checkEnablement == null;
    }

    private static boolean checkHasBeenChangedManuallyAfterFaultyMigration(@Language(value="JSON") String currentJson) throws MigrationException {
        return AnalysisProfileMigrationUtils.getOptionValue(currentJson, ANALYSIS_GROUP_NAME, CHECK_ID) != null;
    }

    private static boolean isAffectedFromFaultyMigration(AnalysisProfileVersionedIndex.AnalysisProfileEditVersion versionBeforeFaultyMigration) throws MigrationException {
        Set<String> languagesBeforeMigration = AnalysisProfileMigrationUtils.getLanguagesInUseJson(versionBeforeFaultyMigration.analysisProfileAsJSON());
        return languagesBeforeMigration.contains("C") && (languagesBeforeMigration.contains("CPP") || languagesBeforeMigration.contains("OBJECTIVE_CPP") || languagesBeforeMigration.contains("CPP_MS_CLI") || languagesBeforeMigration.contains("OPEN_CL"));
    }

    private static boolean checkCanBeRestored(String currentJson) throws MigrationException {
        Set<String> currentLanguages = AnalysisProfileMigrationUtils.getLanguagesInUseJson(currentJson);
        return currentLanguages.contains("C") || currentLanguages.contains("OBJECTIVE_C");
    }

    private static PairList<String, String> getOriginalOptionValues(AnalysisProfileVersionedIndex.AnalysisProfileEditVersion versionBeforeFaultyMigration) throws MigrationException {
        PairList pairs = new PairList();
        String originalEnablement = AnalysisProfileMigrationUtils.getOptionValue(versionBeforeFaultyMigration.analysisProfileAsJSON(), ANALYSIS_GROUP_NAME, CHECK_ID);
        pairs.add((Object)CHECK_ID, (Object)originalEnablement);
        String originalOptionValue = AnalysisProfileMigrationUtils.getOptionValue(versionBeforeFaultyMigration.analysisProfileAsJSON(), ANALYSIS_GROUP_NAME, CHECK_OPTION);
        pairs.add((Object)CHECK_OPTION, (Object)originalOptionValue);
        return pairs;
    }

    private static @Nullable AnalysisProfileVersionedIndex.AnalysisProfileEditVersion findVersionBeforeFaultyMigration(AnalysisProfileVersionedIndex.AnalysisProfileVersionHistory history) throws JsonSerializationException {
        AnalysisProfileVersionedIndex.AnalysisProfileEditVersion versionBeforeFaultyMigration = null;
        for (AnalysisProfileVersionedIndex.AnalysisProfileEditVersion editVersion : history.getAllVersions()) {
            Optional profileVersion;
            String json = editVersion.analysisProfileAsJSON();
            if (json == null || !(profileVersion = TeamscaleVersionContainer.extractVersion((String)json, EAnalysisProfileVersion.class)).isPresent() || ((EAnalysisProfileVersion)((Object)profileVersion.get())).ordinal() >= FAULTY_MIGRATION.ordinal()) continue;
            versionBeforeFaultyMigration = editVersion;
        }
        return versionBeforeFaultyMigration;
    }

    private static String restoreCheckEnablement(@Language(value="JSON") String currentJson, PairList<String, String> optionsAndValues) throws JsonSerializationException {
        ObjectNode analysisProfile = (ObjectNode)JsonUtils.deserializeFromJson((String)currentJson, ObjectNode.class);
        ObjectNode analysisGroup = AnalysisProfileMigrationUtils.getAnalysisGroup(analysisProfile, ANALYSIS_GROUP_NAME);
        if (analysisGroup == null) {
            return currentJson;
        }
        ObjectNode options = (ObjectNode)CCSMAssert.checkedCast((Object)analysisGroup.get("options"), ObjectNode.class);
        if (options == null) {
            options = new ObjectMapper().createObjectNode();
            analysisGroup.set("options", (JsonNode)options);
        }
        for (Pair pair : optionsAndValues) {
            options.put((String)pair.getFirst(), (String)pair.getSecond());
        }
        return JsonUtils.serializeToJSON((Object)analysisProfile);
    }
}

