/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.configuration.tools.message.CppcheckMessageManager;
import com.teamscale.index.configuration.tools.message.RuleBasedMessageManagerBase;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;

public class CppcheckConfiguration
extends ToolConfigurationBase {
    private static final String DESCRIPTION_PATH = "cppcheck";
    private final CppcheckMessageManager messageManager = CppcheckMessageManager.getInstance();

    protected CppcheckConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.CPPCHECK, CppcheckMessageManager.getInstance().getFindingCategoryName(), "Cppcheck");
        this.declareCodeScopeAware();
    }

    private void registerFindings(CodeScopeName codeScope) {
        for (Rule rule : this.messageManager.getRules()) {
            FindingDescriptor finding = this.createFindingDescriptorFor(rule);
            String group = this.getGroup(this.messageManager.getAnalysisGroupNameFor(rule));
            this.registerFinding(finding, group, this.messageManager.getFindingsGroupNameFor(rule), codeScope);
        }
    }

    private FindingDescriptor createFindingDescriptorFor(Rule rule) {
        return new FindingDescriptor(RuleBasedMessageManagerBase.getFindingsDescriptorNameFor(rule), rule.message + " \\(" + rule.id + "\\)", this.tool, (Set)this.tool.getSupportedLanguages(), this.messageManager.getFindingEnablementFor(rule), this.getDescription(rule.id, DESCRIPTION_PATH));
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(this.tool)) {
            return;
        }
        this.registerFindings(template.getCodeScope());
        super.registerQualityIndicators(template, languages, tools);
    }
}

