/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.google.common.collect.Multimap;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.CodeScopeAwareObjectBuilder;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.comment_analysis.identifier.CompoundBreaker;
import com.teamscale.index.findings.powershellscriptanalyzer.PowerShellScriptAnalyzerSynchronizer;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class PowerShellScriptAnalyzerConfiguration
extends ToolConfigurationBase {
    public static final String FINDING_CATEGORY = "PowerShellScriptAnalyzer";
    private static final String MAPPINGS_TSV_FILE = "powershellscriptanalyzer/check-mappings.tsv";
    private static final String POWERSHELL_SCRIPT_ANALYZER_OPTIONS_TSV = "powershellscriptanalyzer/check-options.tsv";
    public static final String EXPECTED_VERSION_FILE = "powershellscriptanalyzer/version.txt";
    private static final String DESCRIPTIONS_DIRECTORY = "powershellscriptanalyzer";

    public PowerShellScriptAnalyzerConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.POWERSHELL_SCRIPT_ANALYZER, FINDING_CATEGORY, DESCRIPTIONS_DIRECTORY, MAPPINGS_TSV_FILE, POWERSHELL_SCRIPT_ANALYZER_OPTIONS_TSV, null);
        this.declareCodeScopeAware();
    }

    protected String getDescription(String checkId, @Nullable String descriptionPath) {
        Object checkDescription = super.getDescription(StringUtils.stripPrefix((String)checkId, (String)"PS"), DESCRIPTIONS_DIRECTORY);
        if (StringUtils.isEmpty((String)checkDescription)) {
            checkDescription = "No description provided for check " + checkId + " by the PowerShellScriptAnalyzer project.";
        }
        return checkDescription;
    }

    protected Multimap<String, ToolCheckOption> readOptions(String optionsFilePath) {
        Multimap optionsMap = super.readOptions(POWERSHELL_SCRIPT_ANALYZER_OPTIONS_TSV);
        Map checkMappingsMap = CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)Resource.of(((Object)((Object)this)).getClass(), (String)MAPPINGS_TSV_FILE));
        for (Map.Entry entry : optionsMap.asMap().entrySet()) {
            String checkId = (String)entry.getKey();
            Collection options = (Collection)entry.getValue();
            String readableCheckName = ((CheckMapping)checkMappingsMap.get(checkId)).getReadableCheckName();
            for (ToolCheckOption toolCheckOption : options) {
                String readableOptionName = StringUtils.concat(CompoundBreaker.breakCompound(toolCheckOption.getReadableName(), false), (String)" ");
                toolCheckOption.setDescription(toolCheckOption.getDescription());
                toolCheckOption.setReadableName(readableCheckName + ": " + readableOptionName);
            }
        }
        return optionsMap;
    }

    public Set<ELanguage> determineLanguages(String checkName) {
        return Collections.singleton(ELanguage.POWERSHELL);
    }

    protected void configureProjectInternal(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        CodeScopeAware selectedChecks = this.getActiveCheckPerCodeScope(proxy.getCodeScopeNames());
        if (selectedChecks == null) {
            return;
        }
        TriggerBuilder trigger = new TriggerBuilder(PowerShellScriptAnalyzerSynchronizer.class, ETriggerConcurrency.PARALLEL);
        trigger.setTriggerParameter("checks", ITriggerParameter.of((Object)selectedChecks));
        trigger.setTriggerParameter("check-options", ITriggerParameter.of(this.extractCheckOptions((CodeScopeAware<Collection<String>>)selectedChecks)));
        proxy.createTrigger(trigger);
        super.configureProjectInternal(proxy);
    }

    private CodeScopeAware<PairList<String, String>> extractCheckOptions(CodeScopeAware<Collection<String>> selectedChecks) {
        CodeScopeAwareObjectBuilder codeScopeAwareBuilder = new CodeScopeAwareObjectBuilder((Object)PairList.emptyPairList());
        for (CodeScopeName codeScopeName : selectedChecks.getCodeScopeNames()) {
            PairList checkOptions = new PairList();
            for (Map.Entry entry : ((Map)this.valueByOptionsId.getValue(codeScopeName)).entrySet()) {
                Object value = entry.getValue();
                if (value == null || StringUtils.isEmpty((String)String.valueOf(value))) continue;
                String optionName = StringUtils.getLastPart((String)((String)entry.getKey()), (String)"#");
                checkOptions.add((Object)optionName, (Object)String.valueOf(value));
                codeScopeAwareBuilder.setContents(codeScopeName, (Object)checkOptions);
            }
        }
        return codeScopeAwareBuilder.build();
    }

    public void validateTools() throws ProjectConfigurationException {
        try {
            PowerShellScriptAnalyzerSynchronizer.verifyPowerShellScriptAnalyzerVersion();
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }
}

