/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class VariableDereferenceInfo {
    private final Map<String, Integer> dereferences = new HashMap<String, Integer>();

    public VariableDereferenceInfo merge(VariableDereferenceInfo other) {
        for (Map.Entry<String, Integer> dereference : other.dereferences.entrySet()) {
            this.addDereference(dereference.getKey(), (int)dereference.getValue());
        }
        return this;
    }

    public void addDereference(String variableName, int offset) {
        this.dereferences.compute(variableName, (key, storedOffset) -> {
            if (storedOffset == null || storedOffset > offset) {
                return offset;
            }
            return storedOffset;
        });
    }

    public void addDereference(TokenPatternMatch match, int groupIndex) {
        String variableName = match.groupString(groupIndex);
        int offset = ((IToken)match.groupTokens(groupIndex).get(0)).getOffset();
        this.addDereference(variableName, offset);
    }

    public void removeDereference(String variableName) {
        this.dereferences.remove(variableName);
    }

    public Set<String> getDereferencedVariables() {
        return this.dereferences.keySet();
    }

    public Integer getDereferenceOffset(String variable) {
        return this.dereferences.get(variable);
    }
}

