/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionTreeNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.SubConditionTreeParser;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.RuleUtils;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.NonNull;

public abstract class ConditionHeuristicBase
implements IConditionHeuristic,
SubConditionTreeParser.IOperatorMapper {
    private final SubConditionTreeParser parser;
    private final IDefUseHeuristic defUseHeuristic;
    private final TokenPattern nullCheckPattern;
    protected static final int IDENTIFIER_IS_NULL_INDEX = 0;
    protected static final int IDENTIFIER_IS_NOT_NULL_INDEX = 1;
    private final TokenPattern instanceOfPattern;
    private final Map<ETokenType, ConditionTreeNode.EOperator> operatorTokens;
    protected static final int NO_TOPLEVEL_OPERATOR = -1;

    public ConditionHeuristicBase(IDefUseHeuristic defUseHeuristic, TokenPattern nullCheckPattern, TokenPattern instanceOfPattern, Map<ETokenType, ConditionTreeNode.EOperator> operatorTokens, ETokenType openingParenthesisToken, ETokenType closingParenthesisToken) {
        this.defUseHeuristic = defUseHeuristic;
        this.nullCheckPattern = nullCheckPattern;
        this.instanceOfPattern = instanceOfPattern;
        this.operatorTokens = operatorTokens;
        this.parser = new SubConditionTreeParser(this, openingParenthesisToken, closingParenthesisToken);
    }

    @Override
    public void createCondition(ControlFlowNode node) {
        node.makeConditional(this.parseCondition(node.getTokens()));
    }

    @Override
    public Condition parseCondition(List<IToken> tokens) {
        List<IToken> filteredTokens = this.filter(tokens);
        ConditionTreeNode root = this.parser.parse(filteredTokens);
        root.flatten();
        return this.createCondition(root);
    }

    protected abstract List<IToken> filter(List<IToken> var1);

    private Condition createCondition(ConditionTreeNode node) {
        if (node.isLeafNode()) {
            node.removeTypeCasts();
            Condition condition = new Condition();
            this.addNullCheckInformation(node, condition);
            this.addInstanceOfInformation(node, condition);
            return condition;
        }
        switch (node.getOperator()) {
            case XOR: {
                Condition mergedCondition = ConditionHeuristicBase.merge(this.createConditions((List<ConditionTreeNode>)node.getChildren()));
                mergedCondition.getYesBranchInfo().clear();
                mergedCondition.getNoBranchInfo().clear();
                return mergedCondition;
            }
            case AND: {
                return this.mergeAndCondition(node);
            }
            case OR: {
                return this.mergeOrCondition(node);
            }
            case NOT: {
                return ConditionHeuristicBase.invert(this.createCondition((ConditionTreeNode)node.getChildren().get(0)));
            }
        }
        CCSMAssert.fail((String)("Unhandled condition operator " + String.valueOf((Object)node.getOperator())));
        return null;
    }

    protected @NonNull Condition mergeAndCondition(ConditionTreeNode node) {
        Condition mergedCondition = ConditionHeuristicBase.merge(this.createConditions((List<ConditionTreeNode>)node.getChildren()));
        mergedCondition.getNoBranchInfo().clear();
        return mergedCondition;
    }

    protected @NonNull Condition mergeOrCondition(ConditionTreeNode node) {
        Condition mergedCondition = ConditionHeuristicBase.merge(this.createConditions((List<ConditionTreeNode>)node.getChildren()));
        mergedCondition.getYesBranchInfo().clear();
        return mergedCondition;
    }

    protected static Condition merge(List<Condition> conditions) {
        Condition mergedCondition = new Condition();
        for (Condition condition : conditions) {
            mergedCondition.getYesBranchInfo().addAll(condition.getYesBranchInfo());
            mergedCondition.getNoBranchInfo().addAll(condition.getNoBranchInfo());
            mergedCondition.getNullCheckedVariables().addAll(condition.getNullCheckedVariables());
        }
        return mergedCondition;
    }

    protected List<Condition> createConditions(List<ConditionTreeNode> children) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (ConditionTreeNode child : children) {
            conditions.add(this.createCondition(child));
        }
        return conditions;
    }

    private static Condition invert(Condition condition) {
        Condition invertedCondition = new Condition();
        invertedCondition.getNoBranchInfo().addAll(condition.getYesBranchInfo());
        invertedCondition.getYesBranchInfo().addAll(condition.getNoBranchInfo());
        invertedCondition.getNullCheckedVariables().addAll(condition.getNullCheckedVariables());
        return invertedCondition;
    }

    protected boolean shouldTreatAsOperator(List<IToken> tokens, int position) {
        return true;
    }

    private void addNullCheckInformation(ConditionTreeNode node, Condition condition) {
        boolean isNullInYesBranch;
        String variableName;
        TokenPatternMatch match;
        Object tokens = node.getTokens();
        if (LanguageGroups.C_AND_DERIVATIVES.contains(TokenStreamUtils.getLanguage(tokens))) {
            tokens = RuleUtils.extractLastCommaExpressionOperand(tokens);
        }
        if ((match = this.nullCheckPattern.findFirstMatch(tokens)) == null) {
            this.addSpecialNullCheckInformation(node, condition);
            return;
        }
        if (match.hasGroup(0)) {
            variableName = match.groupString(0);
            isNullInYesBranch = true;
        } else {
            variableName = match.groupString(1);
            isNullInYesBranch = false;
        }
        if (this.isUnknown(variableName)) {
            return;
        }
        condition.getYesBranchInfo().add((Object)variableName, (Object)isNullInYesBranch);
        condition.getNoBranchInfo().add((Object)variableName, (Object)(!isNullInYesBranch ? 1 : 0));
        condition.getNullCheckedVariables().add(variableName);
    }

    protected void addSpecialNullCheckInformation(ConditionTreeNode node, Condition condition) {
    }

    protected boolean isUnknown(String variableName) {
        return this.defUseHeuristic != null && !this.defUseHeuristic.isKnownVariableName(variableName);
    }

    private void addInstanceOfInformation(ConditionTreeNode node, Condition condition) {
        if (this.instanceOfPattern == null) {
            return;
        }
        TokenPatternMatch match = this.instanceOfPattern.findFirstMatch(node.getTokens());
        if (match == null) {
            return;
        }
        String variableName = match.groupString(0);
        if (this.isUnknown(variableName)) {
            return;
        }
        condition.getYesBranchInfo().add((Object)variableName, (Object)false);
    }

    @Override
    public ConditionTreeNode.EOperator getOperator(List<IToken> tokens, int position) {
        ConditionTreeNode.EOperator operator = this.operatorTokens.get(tokens.get(position).getType());
        if (operator != null && !this.shouldTreatAsOperator(tokens, position)) {
            return null;
        }
        return operator;
    }

    @Override
    public int getPrecedence(NestingAwareTokenIterator iterator, ConditionTreeNode.EOperator operator, IToken token) {
        if (operator == null || !iterator.isTopLevel() || operator == ConditionTreeNode.EOperator.NOT) {
            return -1;
        }
        if (operator == ConditionTreeNode.EOperator.OR) {
            return 0;
        }
        if (operator == ConditionTreeNode.EOperator.AND || operator == ConditionTreeNode.EOperator.XOR) {
            return 1;
        }
        return 2;
    }
}

