/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.abap;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

class AbapPatterns {
    static final TokenPattern IDENTIFIER_LIKE_PATTERN = new TokenPattern().alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.ETokenClass.KEYWORD});
    static final TokenPattern FIELD_SYMBOL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.LT, IDENTIFIER_LIKE_PATTERN, ETokenType.GT});
    static final TokenPattern FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN = new TokenPattern().alternative(new Object[]{FIELD_SYMBOL_PATTERN, new TokenPattern().notPrecededBy((Object)ETokenType.LT).sequence(new Object[]{IDENTIFIER_LIKE_PATTERN}), new TokenPattern().sequence(new Object[]{IDENTIFIER_LIKE_PATTERN}).notFollowedBy((Object)ETokenType.GT)});
    private static final TokenPattern PARAMETERS_ENTRY_PATTERN = new TokenPattern().sequence(new Object[]{IDENTIFIER_LIKE_PATTERN, ETokenType.EQ}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal());
    static final TokenPattern VARIABLE_OR_LITERAL_PATTERN = new TokenPattern().optional(new Object[]{ETokenType.LT}).sequence(new Object[]{EnumSet.of(ETokenType.ETokenClass.IDENTIFIER, ETokenType.ETokenClass.LITERAL)}).optional(new Object[]{ETokenType.GT});
    static final TokenPattern ASSIGNING_OR_REFERENCE_INTO_PATTERN = new TokenPattern().skipTo(new Object[]{ETokenType.ASSIGNING, ETokenType.REFERENCE}).optional(new Object[]{ETokenType.INTO}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal());
    static final TokenPattern METHOD_PARAMETER_WRITES_PATTERN = new TokenPattern().sequence(new Object[]{EnumSet.of(ETokenType.IMPORTING, ETokenType.RECEIVING, ETokenType.CHANGING)}).repeated(new Object[]{PARAMETERS_ENTRY_PATTERN});
    static final List<TokenPattern> ASSIGNMENT_PATTERNS = new ArrayList<TokenPattern>();

    AbapPatterns() {
    }

    private static TokenPattern identifierLikePatternWithGroup(AssignmentGroup assignmentGroup) {
        return new TokenPattern().sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(assignmentGroup.ordinal());
    }

    private static void reverseAssignmentPatterns(Object ... matchTerms) {
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(matchTerms).sequence(new Object[]{VARIABLE_OR_LITERAL_PATTERN}).group(AssignmentGroup.ASSIGNMENT_RIGHT.ordinal()).sequence(new Object[]{EnumSet.of(ETokenType.TO, ETokenType.QUESTION_TO)}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.ASSIGNMENT_LEFT.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(matchTerms).skipTo(new Object[]{ETokenType.TO, ETokenType.QUESTION_TO}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()));
    }

    private static void selectLikePattern(Object ... matchTerms) {
        TokenPattern severalWritesPattern = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()).repeated(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.COMMA}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal())});
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(matchTerms).skipTo(new Object[]{ETokenType.INTO, ETokenType.APPENDING}).optional(new Object[]{ETokenType.CORRESPONDING, ETokenType.FIELDS, ETokenType.OF}).notFollowedBy((Object)ETokenType.TABLE).alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()), severalWritesPattern}));
    }

    private static void readLinePattern() {
        TokenPattern lineValueSubpattern = new TokenPattern().skipTo(new Object[]{ETokenType.LINE_KEYWORD}).sequence(new Object[]{ETokenType.VALUE, ETokenType.INTO}).sequence(new Object[]{IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal());
        TokenPattern fieldValueAssignmentListSubpattern = new TokenPattern().optional(new Object[]{new TokenPattern().sequence(new Object[]{IDENTIFIER_LIKE_PATTERN}).sequence(new Object[]{ETokenType.INTO})}).sequence(new Object[]{IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal());
        TokenPattern fieldValueSubpattern = new TokenPattern().skipTo(new Object[]{ETokenType.FIELD}).sequence(new Object[]{ETokenType.VALUE}).repeated(new Object[]{fieldValueAssignmentListSubpattern});
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.READ, ETokenType.LINE_KEYWORD).alternative(new Object[]{lineValueSubpattern, fieldValueSubpattern}));
    }

    private static void nthIdentifierPattern(int n, Object ... matchTerms) {
        CCSMAssert.isTrue((n > 0 ? 1 : 0) != 0, (String)"Cannot create a pattern for the 0th identifier");
        TokenPattern pattern = AbapPatterns.patternStart(matchTerms);
        for (int i = 0; i < n; ++i) {
            pattern.skipTo(new Object[]{ETokenType.ETokenClass.IDENTIFIER});
        }
        ASSIGNMENT_PATTERNS.add(pattern.group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()));
    }

    private static void allExceptFirstNIdentifiersPattern(int n, Object ... matchTerms) {
        TokenPattern pattern = AbapPatterns.patternStart(matchTerms);
        for (int i = 0; i < n; ++i) {
            pattern.skipTo(new Object[]{ETokenType.ETokenClass.IDENTIFIER});
        }
        TokenPattern identiferPattern = new TokenPattern().skipTo(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal());
        pattern.sequence(new Object[]{identiferPattern});
        pattern.repeated(new Object[]{identiferPattern});
        ASSIGNMENT_PATTERNS.add(pattern);
    }

    private static void assigningOrReferencePattern(Object ... matchTerms) {
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(matchTerms).optional(new Object[]{ASSIGNING_OR_REFERENCE_INTO_PATTERN}).endOfStream());
    }

    private static void assigningOrReferenceOrIntoPattern(Object ... matchTerms) {
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(matchTerms).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).repeated(new Object[]{ETokenType.ARROW, ETokenType.IDENTIFIER}).optional(new Object[]{ETokenType.ARROWSTAR}).sequence(new Object[]{ETokenType.INTO}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(matchTerms).skipTo(new Object[]{ASSIGNING_OR_REFERENCE_INTO_PATTERN}));
    }

    private static void allAfterStopWordPattern(Object stopWord, Object ... matchTerms) {
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(matchTerms).skipTo(new Object[]{stopWord}).repeated(new Object[]{new TokenPattern().skipTo(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal())}));
    }

    private static TokenPattern patternStart(Object ... matchTerms) {
        return new TokenPattern().beginningOfStream().sequence(matchTerms);
    }

    static {
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CATCH).skipTo(new Object[]{ETokenType.INTO}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.EXCEPTION_ASSIGNMENT.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CREATE).skipTo(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.NEW_ASSIGNMENT.ordinal()));
        AbapPatterns.nthIdentifierPattern(2, ETokenType.CALL, ETokenType.TRANSACTION);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.CLEANUP);
        AbapPatterns.reverseAssignmentPatterns(ETokenType.MOVE, ETokenType.EXACT);
        AbapPatterns.reverseAssignmentPatterns(ETokenType.MOVE);
        AbapPatterns.reverseAssignmentPatterns(ETokenType.MOVE_CORRESPONDING, ETokenType.EXACT);
        AbapPatterns.reverseAssignmentPatterns(ETokenType.MOVE_CORRESPONDING);
        AbapPatterns.reverseAssignmentPatterns(ETokenType.UNPACK);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.ASSIGN).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.ASSIGNMENT_RIGHT.ordinal()).sequence(new Object[]{ETokenType.ARROW, ETokenType.MULT}).sequence(new Object[]{EnumSet.of(ETokenType.TO, ETokenType.QUESTION_TO)}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.ASSIGNMENT_LEFT.ordinal()));
        AbapPatterns.reverseAssignmentPatterns(ETokenType.ASSIGN);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.UNASSIGN).sequence(new Object[]{FIELD_SYMBOL_PATTERN}).group(AssignmentGroup.NULLED_FIELD_SYMBOL.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.GET, ETokenType.REFERENCE).skipTo(new Object[]{VARIABLE_OR_LITERAL_PATTERN}).group(AssignmentGroup.ASSIGNMENT_RIGHT.ordinal()).skipTo(new Object[]{VARIABLE_OR_LITERAL_PATTERN}).group(AssignmentGroup.ASSIGNMENT_LEFT.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CLEAR).skipTo(new Object[]{ETokenType.IDENTIFIER}).group(AssignmentGroup.ASSIGNMENT_LEFT.ordinal()).notFollowedBy((Object)ETokenType.GT).skipTo(new Object[]{ETokenType.NULL, VARIABLE_OR_LITERAL_PATTERN}).group(AssignmentGroup.ASSIGNMENT_RIGHT.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CLEAR).skipTo(new Object[]{ETokenType.IDENTIFIER}).group(AssignmentGroup.NULLED_REFERENCE.ordinal()).endOfStream());
        AbapPatterns.nthIdentifierPattern(1, ETokenType.FREE);
        AbapPatterns.nthIdentifierPattern(2, ETokenType.ADD);
        AbapPatterns.nthIdentifierPattern(2, ETokenType.SUBTRACT);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.MULTIPLY);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.DIVIDE);
        AbapPatterns.nthIdentifierPattern(2, ETokenType.ADD_CORRESPONDING);
        AbapPatterns.nthIdentifierPattern(2, ETokenType.SUBTRACT_CORRESPONDING);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.MULTIPLY_CORRESPONDING);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.DIVIDE_CORRESPONDING);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CONCATENATE).skipTo(new Object[]{ETokenType.INTO}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()));
        AbapPatterns.nthIdentifierPattern(1, ETokenType.CONDENSE);
        AbapPatterns.nthIdentifierPattern(2, ETokenType.CONVERT, ETokenType.TEXT);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(EnumSet.of(ETokenType.FIND, ETokenType.REPLACE)).repeated(new Object[]{new TokenPattern().skipTo(new Object[]{ETokenType.RESULTS, ETokenType.COUNT, ETokenType.OFFSET, ETokenType.LENGTH}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal())}).optional(new Object[]{new TokenPattern().skipTo(new Object[]{ETokenType.SUBMATCHES}).repeated(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal())}).endOfStream());
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.REPLACE).skipTo(new Object[]{ETokenType.IN}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()).sequence(new Object[]{ETokenType.WITH}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.ASSIGNMENT_COMPLEX_READ.ordinal()).endOfStream());
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.REPLACE, ETokenType.SECTION).skipTo(new Object[]{ETokenType.OF}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()).sequence(new Object[]{ETokenType.WITH}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.ASSIGNMENT_COMPLEX_READ.ordinal()).endOfStream());
        AbapPatterns.nthIdentifierPattern(3, ETokenType.GET, ETokenType.BIT);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.OVERLAY);
        AbapPatterns.nthIdentifierPattern(2, ETokenType.SET, ETokenType.BIT);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.SHIFT);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.SPLIT).sequence(new Object[]{new TokenPattern().alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.ETokenClass.KEYWORD})}).group(AssignmentGroup.ASSIGNMENT_COMPLEX_READ.ordinal()).sequence(new Object[]{ETokenType.AT}).skipTo(new Object[]{ETokenType.INTO}).optional(new Object[]{ETokenType.TABLE}).repeated(new Object[]{new TokenPattern().alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.ETokenClass.KEYWORD})}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()).endOfStream());
        AbapPatterns.nthIdentifierPattern(1, ETokenType.TRANSLATE);
        AbapPatterns.nthIdentifierPattern(2, ETokenType.WRITE);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.APPEND).skipTo(new Object[]{ETokenType.TO}).sequence(new Object[]{FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()).endOfStream());
        AbapPatterns.assigningOrReferencePattern(ETokenType.APPEND);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.LOOP, ETokenType.AT, ETokenType.SCREEN);
        AbapPatterns.assigningOrReferenceOrIntoPattern(ETokenType.LOOP, ETokenType.AT);
        AbapPatterns.assigningOrReferencePattern(ETokenType.COLLECT);
        AbapPatterns.assigningOrReferencePattern(ETokenType.INSERT);
        AbapPatterns.assigningOrReferencePattern(ETokenType.MODIFY);
        AbapPatterns.assigningOrReferenceOrIntoPattern(ETokenType.READ, ETokenType.TABLE);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.EXTRACT);
        AbapPatterns.allExceptFirstNIdentifiersPattern(1, ETokenType.DESCRIBE, ETokenType.FIELD);
        AbapPatterns.allExceptFirstNIdentifiersPattern(1, ETokenType.DESCRIBE, ETokenType.TABLE);
        AbapPatterns.allExceptFirstNIdentifiersPattern(2, ETokenType.DESCRIBE, ETokenType.DISTANCE);
        AbapPatterns.allExceptFirstNIdentifiersPattern(0, ETokenType.GET, EnumSet.of(ETokenType.CURSOR, ETokenType.PF_STATUS, ETokenType.LOCALE, ETokenType.TIME, ETokenType.BADI));
        AbapPatterns.allExceptFirstNIdentifiersPattern(0, ETokenType.DESCRIBE, ETokenType.LIST);
        AbapPatterns.readLinePattern();
        AbapPatterns.nthIdentifierPattern(2, ETokenType.MESSAGE);
        AbapPatterns.selectLikePattern(ETokenType.FETCH, ETokenType.NEXT, ETokenType.CURSOR);
        AbapPatterns.nthIdentifierPattern(1, ETokenType.OPEN, ETokenType.CURSOR);
        AbapPatterns.selectLikePattern(ETokenType.SELECT);
        AbapPatterns.allExceptFirstNIdentifiersPattern(1, ETokenType.GET, ETokenType.DATASET);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.READ, ETokenType.DATASET).skipTo(new Object[]{ETokenType.INTO}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()).optional(new Object[]{new TokenPattern().skipTo(new Object[]{ETokenType.ACTUAL}).optional(new Object[]{ETokenType.LENGTH}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal())}));
        AbapPatterns.nthIdentifierPattern(2, ETokenType.GET, ETokenType.PARAMETER);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CONVERT, ETokenType.TIME, ETokenType.STAMP, FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN, ETokenType.TIME, ETokenType.ZONE, FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN, ETokenType.INTO).optional(new Object[]{ETokenType.DATE, AbapPatterns.identifierLikePatternWithGroup(AssignmentGroup.OTHER_ASSIGNMENT)}).optional(new Object[]{ETokenType.TIME, AbapPatterns.identifierLikePatternWithGroup(AssignmentGroup.OTHER_ASSIGNMENT)}).optional(new Object[]{ETokenType.DAYLIGHT, ETokenType.SAVING, ETokenType.TIME, AbapPatterns.identifierLikePatternWithGroup(AssignmentGroup.OTHER_ASSIGNMENT)}));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CONVERT, ETokenType.DATE, FIELD_SYMBOL_OR_IDENTIFIER_LIKE_PATTERN).skipTo(new Object[]{ETokenType.INTO}).sequence(new Object[]{ETokenType.TIME, ETokenType.STAMP, AbapPatterns.identifierLikePatternWithGroup(AssignmentGroup.OTHER_ASSIGNMENT), ETokenType.TIME, ETokenType.ZONE, AbapPatterns.identifierLikePatternWithGroup(AssignmentGroup.OTHER_ASSIGNMENT)}));
        AbapPatterns.allExceptFirstNIdentifiersPattern(1, ETokenType.GENERATE, ETokenType.SUBROUTINE, ETokenType.POOL);
        AbapPatterns.allAfterStopWordPattern(ETokenType.MAXIMUM, ETokenType.INSERT, ETokenType.REPORT);
        AbapPatterns.allExceptFirstNIdentifiersPattern(1, ETokenType.READ, ETokenType.REPORT);
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.READ, ETokenType.TEXTPOOL).skipTo(new Object[]{ETokenType.INTO}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.SYNTAX_CHECK).repeatedAtLeastOnce(new Object[]{new TokenPattern().skipTo(new Object[]{ETokenType.MESSAGE, ETokenType.LINE_KEYWORD, ETokenType.INCLUDE, ETokenType.OFFSET, ETokenType.MESSAGE_ID, ETokenType.WORD}).sequence(new Object[]{IDENTIFIER_LIKE_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal())}));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.GET, ETokenType.PROPERTY).skipTo(new Object[]{ETokenType.EQ}).sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()));
        ASSIGNMENT_PATTERNS.add(AbapPatterns.patternStart(ETokenType.CALL, ETokenType.TRANSFORMATION).skipTo(new Object[]{ETokenType.RESULT}).alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.XML}).sequence(new Object[]{AbapPatterns.identifierLikePatternWithGroup(AssignmentGroup.OTHER_ASSIGNMENT)}), new TokenPattern().repeatedAtLeastOnce(new Object[]{PARAMETERS_ENTRY_PATTERN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal()), new TokenPattern().sequence(new Object[]{ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN}).group(AssignmentGroup.OTHER_ASSIGNMENT.ordinal())}));
    }

    static enum AssignmentGroup {
        OTHER_ASSIGNMENT,
        ASSIGNMENT_LEFT,
        ASSIGNMENT_RIGHT,
        NULLED_FIELD_SYMBOL,
        NULLED_REFERENCE,
        NEW_ASSIGNMENT,
        EXCEPTION_ASSIGNMENT,
        ASSIGNMENT_COMPLEX_READ;


        public boolean isInMatch(TokenPatternMatch match) {
            return match.hasGroup(this.ordinal());
        }

        public String getGroupStringFromMatch(TokenPatternMatch match) {
            return match.groupString(this.ordinal());
        }
    }
}

