/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.clike;

import com.google.common.collect.ImmutableSet;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionHeuristicBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionTreeNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.VisibleForTesting;

public class CLikeConditionHeuristic
extends ConditionHeuristicBase {
    private static final TokenPattern CASTING_WITH_CAST_KEYWORDS_PATTERN = new TokenPattern().sequence(new Object[]{EnumSet.of(ETokenType.STATIC_CAST, ETokenType.DYNAMIC_CAST, ETokenType.CONST_CAST, ETokenType.REINTERPRET_CAST)}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, false);
    private static final ImmutableSet<ETokenType> CONDITIONAL_TOKENS = ImmutableSet.of((Object)ETokenType.IF, (Object)ETokenType.ELSEIF, (Object)ETokenType.WHILE);
    protected static Set<ETokenType> nullCheckOperators = new HashSet<ETokenType>(Set.of(ETokenType.EQEQ, ETokenType.EQEQEQ));
    protected static Set<ETokenType> notNullCheckOperators = new HashSet<ETokenType>(Set.of(ETokenType.NOTEQ, ETokenType.NOTEQEQ));
    private static final TokenPattern NULL_CHECK_PATTERN = new TokenPattern().beginningOfStream().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{nullCheckOperators}).alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}), new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).sequence(new Object[]{notNullCheckOperators}).alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}), new TokenPattern().alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}).sequence(new Object[]{nullCheckOperators}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0), new TokenPattern().alternative(new Object[]{ETokenType.NULL, ETokenType.NULL_LITERAL}).sequence(new Object[]{notNullCheckOperators}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1)}).endOfStream();
    @VisibleForTesting
    private static final Map<ETokenType, ConditionTreeNode.EOperator> OPERATOR_TOKENS = new EnumMap<ETokenType, ConditionTreeNode.EOperator>(ETokenType.class);

    protected static TokenPattern identifierMatchingPatternInGroup(int groupId) {
        return new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(groupId).sequence(new Object[]{ETokenType.EQ}).alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.ETokenClass.LITERAL}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).sequence(new Object[]{ETokenType.RPAREN}), new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(groupId).sequence(new Object[]{ETokenType.EQ}).sequence(new Object[]{CASTING_WITH_CAST_KEYWORDS_PATTERN}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).sequence(new Object[]{ETokenType.RPAREN}), new TokenPattern().optional(new Object[]{ETokenType.LPAREN}).optional(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.MULT})}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(groupId).sequence(new Object[]{ETokenType.EQ}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).sequence(new Object[]{ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).repeated(new Object[]{new TokenPattern().alternative(new Object[]{ETokenType.DOT, ETokenType.POINTERTO}).sequence(new Object[]{ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true)}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).optional(new Object[]{ETokenType.RPAREN}), new TokenPattern().optional(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER, ETokenType.MULT})}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(groupId).sequence(new Object[]{ETokenType.EQ}).alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.ETokenClass.LITERAL, ETokenType.NULLPTR}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true), new TokenPattern().repeated(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(groupId)}).repeated(new Object[]{ETokenType.RPAREN});
    }

    public CLikeConditionHeuristic(IDefUseHeuristic defUseHeuristic, ETokenType instanceOfKeyword) {
        super(defUseHeuristic, NULL_CHECK_PATTERN, CLikeConditionHeuristic.createInstanceOfPattern(instanceOfKeyword), OPERATOR_TOKENS, ETokenType.LPAREN, ETokenType.RPAREN);
    }

    public CLikeConditionHeuristic(IDefUseHeuristic defUseHeuristic, ETokenType instanceOfKeyword, Set<ETokenType> additionalEqualsOperators, Set<ETokenType> additionalNotEqualsOperators) {
        super(defUseHeuristic, NULL_CHECK_PATTERN, CLikeConditionHeuristic.createInstanceOfPattern(instanceOfKeyword), OPERATOR_TOKENS, ETokenType.LPAREN, ETokenType.RPAREN);
        nullCheckOperators.addAll(additionalEqualsOperators);
        notNullCheckOperators.addAll(additionalNotEqualsOperators);
    }

    protected CLikeConditionHeuristic(IDefUseHeuristic defUseHeuristic, TokenPattern nullCheckPattern, ETokenType instanceOfKeyword) {
        super(defUseHeuristic, nullCheckPattern, CLikeConditionHeuristic.createInstanceOfPattern(instanceOfKeyword), OPERATOR_TOKENS, ETokenType.LPAREN, ETokenType.RPAREN);
    }

    private static TokenPattern createInstanceOfPattern(ETokenType instanceOfKeyword) {
        return new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{instanceOfKeyword, ETokenType.IDENTIFIER}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).endOfStream();
    }

    private static boolean isLikelyForLoopCondition(List<IToken> tokens) {
        return tokens.stream().noneMatch(token -> CONDITIONAL_TOKENS.contains((Object)token.getType()));
    }

    @Override
    protected List<IToken> filter(List<IToken> tokens) {
        int endIndex;
        if (CLikeConditionHeuristic.isLikelyForLoopCondition(tokens)) {
            return tokens;
        }
        int startIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LPAREN) + 1;
        if (startIndex == -1) {
            startIndex = 0;
        }
        if ((endIndex = TokenStreamUtils.lastTokenMatching(tokens, (ITokenMatcher)ETokenType.RPAREN)) == -1) {
            endIndex = tokens.size();
        }
        return tokens.subList(startIndex, endIndex);
    }

    static {
        OPERATOR_TOKENS.put(ETokenType.AND, ConditionTreeNode.EOperator.AND);
        OPERATOR_TOKENS.put(ETokenType.ANDAND, ConditionTreeNode.EOperator.AND);
        OPERATOR_TOKENS.put(ETokenType.OR, ConditionTreeNode.EOperator.OR);
        OPERATOR_TOKENS.put(ETokenType.OROR, ConditionTreeNode.EOperator.OR);
        OPERATOR_TOKENS.put(ETokenType.NOT, ConditionTreeNode.EOperator.NOT);
        OPERATOR_TOKENS.put(ETokenType.XOR, ConditionTreeNode.EOperator.XOR);
    }
}

