/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp;

import com.teamscale.index.dataflow.controlflowgraph.Condition;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ConditionTreeNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.clike.CLikeConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.CDataflowUtils;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CppConditionHeuristic
extends CLikeConditionHeuristic {
    private static final TokenPattern CPP_NULL_CHECK_PATTERN = new TokenPattern().beginningOfStream().alternative(new Object[]{new TokenPattern().beginningOfStream().alternative(new Object[]{new TokenPattern().sequence(new Object[]{CLikeConditionHeuristic.identifierMatchingPatternInGroup(0).notPrecededBy((Object)ETokenType.MULT), ETokenType.EQEQ}).sequence(new Object[]{CDataflowUtils.NULL_VALUE_PATTERN}), new TokenPattern().sequence(new Object[]{CLikeConditionHeuristic.identifierMatchingPatternInGroup(1).notPrecededBy((Object)ETokenType.MULT), ETokenType.NOTEQ}).sequence(new Object[]{CDataflowUtils.NULL_VALUE_PATTERN}), new TokenPattern().sequence(new Object[]{CDataflowUtils.NULL_VALUE_PATTERN, ETokenType.EQEQ}).sequence(new Object[]{CLikeConditionHeuristic.identifierMatchingPatternInGroup(0).notPrecededBy((Object)ETokenType.MULT)}), new TokenPattern().sequence(new Object[]{CDataflowUtils.NULL_VALUE_PATTERN, ETokenType.NOTEQ}).sequence(new Object[]{CLikeConditionHeuristic.identifierMatchingPatternInGroup(1).notPrecededBy((Object)ETokenType.MULT)})}).endOfStream(), new TokenPattern().sequence(new Object[]{CLikeConditionHeuristic.identifierMatchingPatternInGroup(1)}).notPrecededBy((Object)ETokenType.MULT).sequence(new Object[]{ETokenType.GT, CDataflowUtils.NULL_VALUE_PATTERN}), new TokenPattern().sequence(new Object[]{CLikeConditionHeuristic.identifierMatchingPatternInGroup(1)}).notPrecededBy((Object)ETokenType.MULT)}).endOfStream();
    private static final int METHOD_NAME_INDEX = 2;
    private static final TokenPattern METHOD_CALL_WITH_NO_PARAMETERS_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{CLikeConditionHeuristic.identifierMatchingPatternInGroup(1)}).sequence(new Object[]{ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(2).sequence(new Object[]{ETokenType.LPAREN, ETokenType.RPAREN}).endOfStream();

    public CppConditionHeuristic(IDefUseHeuristic defUseHeuristic) {
        super(defUseHeuristic, CPP_NULL_CHECK_PATTERN, ETokenType.INSTANCEOF);
    }

    @Override
    protected List<IToken> filter(List<IToken> input) {
        List<IToken> result = CppConditionHeuristic.filterBuiltinFunctions(input);
        result = CppConditionHeuristic.filterFunctionArguments(result);
        result = CppConditionHeuristic.filterTrivialComparisons(result);
        return super.filter(result);
    }

    private static List<IToken> filterTrivialComparisons(List<IToken> input) {
        ArrayList<IToken> result = new ArrayList<IToken>(input.size());
        for (int i = 0; i < input.size(); ++i) {
            IToken current = input.get(i);
            boolean isTrue = TokenStreamTextUtils.is((IToken)current, (ETokenType)ETokenType.BOOLEAN_LITERAL, (String)"true");
            boolean isFalse = TokenStreamTextUtils.is((IToken)current, (ETokenType)ETokenType.BOOLEAN_LITERAL, (String)"false");
            if ((isTrue || isFalse) && TokenStreamUtils.hasTokenTypeSequence(input, (int)i, (ETokenType[])new ETokenType[]{ETokenType.BOOLEAN_LITERAL, ETokenType.EQEQ, ETokenType.LPAREN})) {
                if (current.getText().equals("true")) {
                    ++i;
                    continue;
                }
                if (!current.getText().equals("false")) continue;
                result.add(current.newToken(ETokenType.NOT, current.getOffset(), current.getLineNumber(), "!", current.getOriginId()));
                ++i;
                continue;
            }
            if ((isTrue || isFalse) && TokenStreamUtils.hasTokenTypeSequence(input, (int)i, (ETokenType[])new ETokenType[]{ETokenType.BOOLEAN_LITERAL, ETokenType.NOTEQ, ETokenType.LPAREN})) {
                if (current.getText().equals("true")) {
                    result.add(current.newToken(ETokenType.NOT, current.getOffset(), current.getLineNumber(), "!", current.getOriginId()));
                    ++i;
                    continue;
                }
                if (!current.getText().equals("false")) continue;
                ++i;
                continue;
            }
            result.add(current);
        }
        return result;
    }

    private static List<IToken> filterBuiltinFunctions(List<IToken> input) {
        HashSet builtinFunctions = CollectionUtils.asHashSet((Object[])new String[]{"__builtin_expect", "__builtin_expect_with_probability"});
        int functionCallIndex = TokenStreamTextUtils.findFirst(input, (Set)builtinFunctions);
        if (functionCallIndex == -1 || !TokenStreamUtils.hasTokenTypeSequence(input, (int)(functionCallIndex + 1), (ETokenType[])new ETokenType[]{ETokenType.LPAREN})) {
            return input;
        }
        int startOfSecondParameterIndex = TokenStreamUtils.findFirstTopLevel(input, (int)(functionCallIndex + 2), (ITokenMatcher)ETokenType.COMMA, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE));
        if (startOfSecondParameterIndex == -1) {
            return input;
        }
        int endOfParametersIndex = TokenStreamUtils.findFirstTopLevel(input, (int)startOfSecondParameterIndex, (ITokenMatcher)ETokenType.RPAREN, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE));
        if (endOfParametersIndex == -1) {
            return input;
        }
        ArrayList<IToken> result = new ArrayList<IToken>(input);
        result.subList(startOfSecondParameterIndex, endOfParametersIndex).clear();
        result.remove(functionCallIndex);
        return result;
    }

    private static List<IToken> filterFunctionArguments(List<IToken> input) {
        ArrayList<IToken> result = new ArrayList<IToken>(input);
        int currentIndex = 0;
        while (TokenStreamUtils.containsSequence(result, (int)currentIndex, (int)result.size(), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.LPAREN})) {
            int argsStartIndex = TokenStreamUtils.firstTokenOfTypeSequence(result, (int)currentIndex, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}) + 2;
            int parenEndIndex = TokenStreamUtils.findMatchingClosingToken(result, (int)argsStartIndex, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            CCSMAssert.isTrue((parenEndIndex != -1 ? 1 : 0) != 0, (String)"Missing closing parenthesis detected.");
            result.subList(argsStartIndex, parenEndIndex).clear();
            currentIndex = argsStartIndex + 1;
        }
        return result;
    }

    @Override
    protected void addSpecialNullCheckInformation(ConditionTreeNode node, Condition condition) {
        TokenPatternMatch match = METHOD_CALL_WITH_NO_PARAMETERS_PATTERN.findFirstMatch(node.getTokens());
        if (match == null || !"has_value".equals(match.groupString(2))) {
            return;
        }
        String variableName = match.groupString(1);
        if (this.isUnknown(variableName)) {
            return;
        }
        condition.getYesBranchInfo().add((Object)variableName, (Object)false);
        condition.getNullCheckedVariables().add(variableName);
    }
}

