/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.cpp.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class GotoRule
implements IControlFlowRule {
    private static final TokenPattern DIRECT_GOTO_TARGET_PATTERN = new TokenPattern().alternative(new Object[]{ETokenType.IDENTIFIER, ETokenType.ETokenClass.KEYWORD}).group(0);
    private static final TokenPattern COMPUTED_GOTO_TARGET_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.MULT, new TokenPattern().alternative(new Object[]{new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(1), new TokenPattern().optional(new Object[]{ETokenType.LPAREN}).skipTo(new Object[]{ETokenType.ANDAND}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0)})});
    private static final TokenPattern GOTO_PATTERN = new TokenPattern().beginningOfStream().skipNested((Object)ETokenType.LBRACK, (Object)ETokenType.RBRACK, true).sequence(new Object[]{ETokenType.GOTO}).alternative(new Object[]{DIRECT_GOTO_TARGET_PATTERN, COMPUTED_GOTO_TARGET_PATTERN});

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) {
        ShallowEntity entity = entities.get(0);
        UnmodifiableList tokens = entity.ownStartTokens();
        ControlFlowNode node = context.createNode((List<IToken>)tokens, false);
        List<String> targetLabels = GotoRule.extractLabels((List<IToken>)tokens, context);
        for (String label : targetLabels) {
            context.getCodeLabelManager().addJumpNode(node, label);
        }
        return new IControlFlowRule.Result(1, node, (List<ControlFlowNode>)CollectionUtils.emptyList());
    }

    private static List<String> extractLabels(List<IToken> tokens, DataFlowContext context) {
        TokenPatternMatch match = GOTO_PATTERN.findFirstMatch(tokens);
        CCSMAssert.isNotNull((Object)match, (String)SourceCodeMessageUtils.createMessage((String)"Found malformed goto", tokens, null));
        String knownTargetLabel = match.groupString(0);
        if (!knownTargetLabel.isEmpty()) {
            return Collections.singletonList(knownTargetLabel);
        }
        String unknownTargetLabel = match.groupString(1);
        if (!unknownTargetLabel.isEmpty()) {
            return context.getCodeLabelManager().getAllLabelsInCurrentFunction();
        }
        return Collections.emptyList();
    }
}

