/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.RuleUtils;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Arrays;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;

public abstract class MethodRuleBase
implements IControlFlowRule {
    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        ShallowEntity methodEntity = entities.get(0);
        List<IToken> parameterListTokens = this.extractParameterListTokens(methodEntity);
        VariableReadWriteInfo parameterInfo = context.getDefUseHeuristic().parseParameterList(parameterListTokens, methodEntity);
        ControlFlowNode parameterNode = context.createNode(parameterListTokens, parameterInfo);
        ControlFlowNode lastMethodInitializerNode = this.insertAdditionalInitializerNodes(parameterNode, entities, context);
        ControlFlowNode exitNode = MethodRuleBase.finalizeMethodTransformation(context, creator, methodEntity, lastMethodInitializerNode);
        return new IControlFlowRule.Result(1, parameterNode, Arrays.asList(exitNode));
    }

    protected ControlFlowNode insertAdditionalInitializerNodes(ControlFlowNode parameterNode, List<ShallowEntity> entities, DataFlowContext context) {
        return parameterNode;
    }

    protected abstract List<IToken> extractParameterListTokens(ShallowEntity var1);

    private static ControlFlowNode finalizeMethodTransformation(DataFlowContext context, ControlFlowCreator creator, ShallowEntity methodEntity, ControlFlowNode parameterNode) throws ConQATException {
        IControlFlowRule.Result result = RuleUtils.transformInNewScope(creator, context, (List<ShallowEntity>)methodEntity.getChildren());
        ControlFlowNode.link(parameterNode, result.getEntryNode());
        ControlFlowNode exitNode = context.createSyntheticNode();
        for (ControlFlowNode node : result.getExitNodes()) {
            ControlFlowNode.link(node, exitNode);
        }
        for (ControlFlowNode node : context.getReturnNodes()) {
            ControlFlowNode.link(node, exitNode);
        }
        context.getCodeLabelManager().connectAllNodesAndClear();
        return exitNode;
    }
}

