/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.configuration.ETaintAnalysisOptions;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintAnalysisCallHandler;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysis;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysisState;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.TaintInfluenceMap;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.TaintSinkRecognizer;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.TaintSourceRecognizer;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphField;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSink;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSource;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.VariableTaintGraphReference;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.abap.AbapMethodCallRecognizer;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class MethodTaintAnalysisNodeHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TaintInfluenceMap influenceMap;
    private EnumSet<ETaintAnalysisOptions> options;
    private final MethodTaintGraphGenerationAnalysisState infeasibleState;
    private TokenElementInfo element;
    private StringOffsetTransformer offsetTransformer;
    private LineOffsetConverter rawLineOffsetConverter;
    private MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreatorForNode;
    private ControlFlowGraph currentCFG;

    public MethodTaintAnalysisNodeHandler(EnumSet<ETaintAnalysisOptions> options, MethodTaintGraphGenerationAnalysisState infeasibleState, TokenElementInfo element, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter, MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreatorForNode, ControlFlowGraph currentCFG, TaintInfluenceMap influenceMap) {
        this.options = options;
        this.infeasibleState = infeasibleState;
        this.element = element;
        this.offsetTransformer = offsetTransformer;
        this.rawLineOffsetConverter = rawLineOffsetConverter;
        this.ssaCreatorForNode = ssaCreatorForNode;
        this.currentCFG = currentCFG;
        this.influenceMap = influenceMap;
    }

    MethodTaintGraphGenerationAnalysisState processNode(ControlFlowNode cfgNode, MethodTaintGraphGenerationAnalysisState inState) {
        MethodTaintGraphGenerationAnalysisState outState = MethodTaintGraphGenerationAnalysisState.cloneFrom(inState, cfgNode);
        if (cfgNode.isAssumeNode() || cfgNode.isSynthetic() || cfgNode.getTokens().isEmpty()) {
            return outState;
        }
        if (cfgNode.continuesWithLoopReturnEdge()) {
            return this.infeasibleState;
        }
        PairList<TaintGraphSource, TaintGraphReferenceBase> sourceRelationsInNode = TaintSourceRecognizer.getSourceRelations(cfgNode, outState, this.ssaCreatorForNode, this.getElement(), this.offsetTransformer, this.rawLineOffsetConverter);
        sourceRelationsInNode.forEach((source, influencedRef) -> this.influenceMap.addInfluenceOn((TaintGraphReferenceBase)influencedRef, CollectionUtils.asHashSet((Object[])new TaintGraphReferenceBase[]{source})));
        PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelationsInNode = TaintSinkRecognizer.getSinkRelations(cfgNode, outState, this.getElement(), this.offsetTransformer, this.rawLineOffsetConverter);
        sinkRelationsInNode.forEach((influenceRef, sink) -> this.influenceMap.addInfluenceOn((TaintGraphReferenceBase)sink, this.influenceMap.getInfluencesRecursiveOn((TaintGraphReferenceBase)influenceRef)));
        Optional methodInvocationDetails = AbapMethodCallRecognizer.parse(cfgNode.getTokens());
        if (sourceRelationsInNode.isEmpty() && sinkRelationsInNode.isEmpty()) {
            if (methodInvocationDetails.isPresent()) {
                if (this.options.contains((Object)ETaintAnalysisOptions.IGNORE_CALLS_TO_SAP_LIBRARY) && MethodTaintAnalysisNodeHandler.isCallToSapLibrary((AbapMethodCallRecognizer.MethodCallInfo)methodInvocationDetails.get())) {
                    this.clearTaintOnAssignee((AbapMethodCallRecognizer.MethodCallInfo)methodInvocationDetails.get(), outState);
                } else {
                    new MethodTaintAnalysisCallHandler((AbapMethodCallRecognizer.MethodCallInfo)methodInvocationDetails.get(), outState, cfgNode, this.currentCFG, this.element, this.offsetTransformer, this.rawLineOffsetConverter, this.ssaCreatorForNode, this.influenceMap).processMethodCall();
                }
            } else if (cfgNode.getTokens().get(0).getType() == ETokenType.DATA) {
                this.processVariableInitialization(cfgNode, outState);
            } else if (cfgNode.getTokens().get(0).getType() == ETokenType.CLEAR) {
                this.processVariableCleaning(cfgNode, outState);
            } else {
                this.processOtherStatement(cfgNode, outState);
            }
        }
        return outState;
    }

    private void processVariableCleaning(ControlFlowNode cfgNode, MethodTaintGraphGenerationAnalysisState outState) {
        List<IToken> tokens = cfgNode.getTokens();
        CCSMAssert.isTrue((tokens.get(0).getType() == ETokenType.CLEAR ? 1 : 0) != 0, (String)"Only call this function with statements starting with 'CLEAR'.");
        if (tokens.size() < 2) {
            return;
        }
        String variableName = tokens.get(1).getText();
        if (outState.containsReferenceFor(variableName)) {
            this.clearTaintOnReference(outState, variableName, outState.getReferenceFor(variableName));
        }
        String methodIdentifier = TaintAnalysisUtils.buildMethodIdentifier(this.getElement().getUniformPath(), this.currentCFG.getMethodName());
        this.clearTaintOnReference(outState, variableName, new VariableTaintGraphReference(variableName, this.ssaCreatorForNode.getNextSSA(), TaintGraphReferenceBase.EReferenceType.LOCAL, null, methodIdentifier));
    }

    public TokenElementInfo getElement() {
        return this.element;
    }

    private static boolean isCallToSapLibrary(AbapMethodCallRecognizer.MethodCallInfo methodCallInfo) {
        String containerTypeName = null;
        if (methodCallInfo.isStaticCall()) {
            containerTypeName = methodCallInfo.getMethodContainerName();
        }
        if (containerTypeName != null && !containerTypeName.isEmpty()) {
            char firstLetter = containerTypeName.toUpperCase().charAt(0);
            return 'A' <= firstLetter && firstLetter <= 'X';
        }
        return false;
    }

    private void clearTaintOnAssignee(AbapMethodCallRecognizer.MethodCallInfo methodCallInfo, MethodTaintGraphGenerationAnalysisState outState) {
        String assignee = methodCallInfo.getAssignee();
        if (assignee == null || assignee.isEmpty()) {
            return;
        }
        TaintGraphReferenceBase assigneeReference = MethodTaintGraphGenerationAnalysis.getReference(assignee, outState, this.ssaCreatorForNode);
        this.clearTaintOnReference(outState, assignee, assigneeReference);
    }

    private void clearTaintOnReference(MethodTaintGraphGenerationAnalysisState outState, String variableName, TaintGraphReferenceBase variableReference) {
        boolean needToClone = outState.containsReferenceFor(variableName);
        if (needToClone) {
            variableReference = variableReference.cloneWithNewSSA(this.ssaCreatorForNode.getNextSSA(), null);
        }
        outState.putReferenceFor(variableName, variableReference);
        this.influenceMap.addInfluenceOn(variableReference, new HashSet<TaintGraphReferenceBase>());
    }

    private void processVariableInitialization(ControlFlowNode cfgNode, MethodTaintGraphGenerationAnalysisState outState) {
        VariableReadWriteInfo rwInfo = cfgNode.getReadWriteInfo();
        Set<TaintGraphReferenceBase> readReferences = this.influenceMap.getInfluencesRecursiveOn(MethodTaintGraphGenerationAnalysis.getReferences(rwInfo.getReads(), outState, this.ssaCreatorForNode));
        Set writtenVariables = rwInfo.getAllWrites().stream().map(VariableWrite::getChangedVariable).collect(Collectors.toSet());
        for (String declaredVariableName : writtenVariables) {
            TaintGraphReferenceBase variableReference;
            if (outState.containsReferenceFor(declaredVariableName)) {
                LOGGER.warn("duplicate variable declaration? " + declaredVariableName + " in " + this.currentCFG.getMethodName());
            }
            if (this.currentCFG.getMethodName().endsWith("START-OF-SELECTION")) {
                TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens(cfgNode.getTokens(), this.getElement(), this.offsetTransformer, this.rawLineOffsetConverter);
                variableReference = new TaintGraphField(this.getElement().getUniformPath(), declaredVariableName, location, this.ssaCreatorForNode.getNextSSA(), outState.getMethodIdentifier());
            } else {
                variableReference = new VariableTaintGraphReference(declaredVariableName, this.ssaCreatorForNode.getNextSSA(), TaintGraphReferenceBase.EReferenceType.LOCAL, null, outState.getMethodIdentifier());
            }
            outState.putReferenceFor(declaredVariableName, variableReference);
            this.influenceMap.addInfluenceOn(variableReference, readReferences);
        }
    }

    private void processOtherStatement(ControlFlowNode cfgNode, MethodTaintGraphGenerationAnalysisState outState) {
        VariableReadWriteInfo rwInfo = cfgNode.getReadWriteInfo();
        TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens(cfgNode.getTokens(), this.element, this.offsetTransformer, this.rawLineOffsetConverter);
        Set<TaintGraphReferenceBase> writtenReferences = MethodTaintGraphGenerationAnalysis.getReferences(rwInfo.getAllWrites().stream().map(assignment -> assignment.getChangedVariable()).filter(variable -> variable != null).collect(Collectors.toSet()), outState, this.ssaCreatorForNode);
        Set<TaintGraphReferenceBase> readReferences = this.influenceMap.getInfluencesRecursiveOn(MethodTaintGraphGenerationAnalysis.getReferences(rwInfo.getReads(), outState, this.ssaCreatorForNode));
        for (TaintGraphReferenceBase reference : writtenReferences) {
            TaintGraphReferenceBase newSSA = reference.cloneWithNewSSA(this.ssaCreatorForNode.getNextSSA(), (ElementLocation)location);
            if (reference.getType() == TaintGraphReferenceBase.EReferenceType.FIELD) {
                outState.putReferenceFor(((TaintGraphField)reference).getSimpleFieldName(), newSSA);
            } else {
                outState.putReferenceFor(reference.getReferenceName(), newSSA);
            }
            this.influenceMap.addInfluenceOn(newSSA, readReferences);
        }
    }
}

