/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

class TaintInfluenceMap {
    private final Map<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> innerMap = new HashMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>>();

    TaintInfluenceMap() {
    }

    boolean containsInfluenceOn(TaintGraphReferenceBase reference) {
        return this.innerMap.containsKey(reference);
    }

    boolean isInfluencedByAll(TaintGraphReferenceBase reference, Set<TaintGraphReferenceBase> potentialInfluences) {
        if (this.containsInfluenceOn(reference)) {
            Set<TaintGraphReferenceBase> influences = this.getInfluencesOn(reference);
            return influences.containsAll(potentialInfluences);
        }
        return false;
    }

    Set<TaintGraphReferenceBase> getInfluencesOn(TaintGraphReferenceBase reference) {
        return this.innerMap.get(reference);
    }

    Set<TaintGraphReferenceBase> getInfluencesOrEmpty(TaintGraphReferenceBase currentReference) {
        return this.innerMap.getOrDefault(currentReference, Collections.emptySet());
    }

    void addInfluenceOn(TaintGraphReferenceBase reference, Set<TaintGraphReferenceBase> newInfluences) {
        Set influences = this.innerMap.getOrDefault(reference, new HashSet());
        influences.addAll(newInfluences);
        this.innerMap.put(reference, influences);
    }

    Set<TaintGraphReferenceBase> getInfluencesRecursiveOn(Set<TaintGraphReferenceBase> references) {
        HashSet<TaintGraphReferenceBase> influences = new HashSet<TaintGraphReferenceBase>();
        for (TaintGraphReferenceBase reference : references) {
            influences.addAll(this.getInfluencesRecursiveOn(reference));
        }
        influences.addAll(references);
        return influences;
    }

    Set<TaintGraphReferenceBase> getInfluencesRecursiveOn(TaintGraphReferenceBase reference) {
        HashSet<TaintGraphReferenceBase> influences = new HashSet<TaintGraphReferenceBase>();
        influences.add(reference);
        influences.addAll(this.innerMap.getOrDefault(reference, Collections.emptySet()));
        return influences;
    }

    UnmodifiableMap<TaintGraphReferenceBase, Set<TaintGraphReferenceBase>> getUnmodifiableInnerMap() {
        return CollectionUtils.asUnmodifiable(this.innerMap);
    }
}

