/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallInputValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallValueReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class MethodCallReturnValueReference
extends MethodCallValueReferenceBase {
    private static final long serialVersionUID = 1L;
    private static final String MCR_REFERENCE_NAME_PREFIX = "MCR_";
    private final EReturnParameterType returnValueType;

    public MethodCallReturnValueReference(MethodCallReference methodCall, EReturnParameterType returnValueType, String parameterId, ElementLocation location, String referenceContainerMethodId) {
        super(MethodCallReturnValueReference.buildReferenceName(MCR_REFERENCE_NAME_PREFIX, methodCall, returnValueType.toString(), parameterId), location, methodCall, parameterId, referenceContainerMethodId);
        this.returnValueType = returnValueType;
        if (returnValueType == EReturnParameterType.ASSIGNEE) {
            CCSMAssert.isTrue((boolean)parameterId.equals(""), (String)"Wrong parameter id");
        }
    }

    @Override
    public TaintGraphReferenceBase.EReferenceType getType() {
        return TaintGraphReferenceBase.EReferenceType.METHOD_CALL_RETURN;
    }

    public String toString() {
        return super.getReferenceName();
    }

    @Override
    public TaintGraphReferenceBase cloneWithNewSSA(String newSSA, ElementLocation location) {
        throw new UnsupportedOperationException("Should not overwrite methodCallReturnValues (No SSA needed).");
    }

    public MethodCallReference getMethodCallReference() {
        return this.methodCall;
    }

    public Optional<MethodCallInputValueReference> getCallerInputReferenceBeforeCall() {
        switch (this.returnValueType.ordinal()) {
            case 0: 
            case 1: {
                return Optional.empty();
            }
            case 2: 
            case 3: 
            case 4: {
                return this.getCallerInputForNamedParameter();
            }
            case 6: {
                return this.getCallerInputForField();
            }
            case 5: {
                return this.getCallerInputForUnnamedParameter();
            }
        }
        CCSMAssert.fail((String)("There is some new enum value we have not covered: " + String.valueOf((Object)this.returnValueType)));
        CCSMAssert.fail((String)"One of the switch cases does not end in a return statement!");
        return Optional.empty();
    }

    private Optional<MethodCallInputValueReference> getCallerInputForUnnamedParameter() throws AssertionError {
        CCSMAssert.isTrue((boolean)StringUtils.isInteger((String)this.getParameterId()), (String)"found non-numeric index in UNNAMED parameter in CallReference");
        int index = Integer.parseInt(this.getParameterId());
        CCSMAssert.isTrue((boolean)((MethodCallReturnValueReference)this.methodCall.getUnnamedParameters().getSecond(index)).equals(this), (String)("found violation of CallReference structure (UNNAMED " + this.getReferenceName() + ")"));
        return Optional.of((MethodCallInputValueReference)this.methodCall.getUnnamedParameters().getFirst(index));
    }

    private Optional<MethodCallInputValueReference> getCallerInputForField() throws AssertionError {
        Pair<MethodCallInputValueReference, MethodCallReturnValueReference> beforeAfterCallPair = this.methodCall.getFieldReferences().get(this.getParameterId());
        CCSMAssert.isNotNull(beforeAfterCallPair);
        CCSMAssert.isTrue((boolean)((MethodCallReturnValueReference)beforeAfterCallPair.getSecond()).equals(this), (String)("found violation of CallReference structure (FIELD " + this.getReferenceName() + ")"));
        return Optional.of((MethodCallInputValueReference)beforeAfterCallPair.getFirst());
    }

    private Optional<MethodCallInputValueReference> getCallerInputForNamedParameter() throws AssertionError {
        Pair<MethodCallInputValueReference, MethodCallReturnValueReference> beforeAfterCallPair = this.methodCall.getNamedParameters().get(this.getParameterId());
        CCSMAssert.isNotNull(beforeAfterCallPair);
        CCSMAssert.isTrue((boolean)((MethodCallReturnValueReference)beforeAfterCallPair.getSecond()).equals(this), (String)("found violation of CallReference structure (NAMED " + this.getReferenceName() + ")"));
        return Optional.of((MethodCallInputValueReference)beforeAfterCallPair.getFirst());
    }

    public Set<TaintGraphReferenceBase> getInfluencingParametersIfNoImplementingMethodKnown() {
        if (this.returnValueType == EReturnParameterType.FIELD) {
            Optional<Map.Entry> beforeAfterPair = this.methodCall.getFieldReferences().entrySet().stream().filter(entry -> ((MethodCallReturnValueReference)((Pair)entry.getValue()).getSecond()).equals(this)).findAny();
            CCSMAssert.isTrue((boolean)beforeAfterPair.isPresent(), (String)("found violation in CallReference structure (FIELD " + this.getReferenceName() + ")"));
            return Collections.singleton((TaintGraphReferenceBase)((Pair)beforeAfterPair.get().getValue()).getFirst());
        }
        return this.methodCall.getAllInfluencingParameters();
    }

    public EReturnParameterType getReturnValueType() {
        return this.returnValueType;
    }

    @Override
    public String toFindingDescription() {
        if (this.returnValueType == EReturnParameterType.ASSIGNEE) {
            return "Possibly tainted return value in assignee `" + this.getReferenceName() + "`";
        }
        return "Possibly tainted return value in parameter `" + this.getReferenceName() + "`";
    }

    @IndexValueClass
    public static enum EReturnParameterType {
        ASSIGNEE,
        RECEIVING,
        IMPORTING,
        CHANGING,
        NAMED,
        UNNAMED,
        FIELD;

    }
}

