/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import com.teamscale.index.dependencies.IFileDependencyFilteringStrategy;
import com.teamscale.index.dependencies.TypeLookupEnvironmentFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class NearestNeighborFileDependencyFilteringStrategy
implements IFileDependencyFilteringStrategy {
    @Override
    public Collection<String> filterDependencies(String uniformPath, Collection<String> uniformPaths, TypeLookupEnvironmentFactory typeLookupEnvironmentFactory) {
        if (uniformPaths.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singleton(NearestNeighborFileDependencyFilteringStrategy.getNearestPath(uniformPath, uniformPaths));
    }

    public static String getNearestPath(String uniformPath, Collection<String> paths) {
        CCSMAssert.isFalse((boolean)paths.isEmpty(), (String)"Paths must not be empty");
        if (paths.contains(uniformPath)) {
            return uniformPath;
        }
        if (paths.size() == 1) {
            return (String)CollectionUtils.getAny(paths);
        }
        Comparator<String> distanceComparator = Comparator.comparingInt(path -> NearestNeighborFileDependencyFilteringStrategy.getDistance(uniformPath, path));
        Comparator<String> commonPrefixComparator = Comparator.comparingInt(path -> NearestNeighborFileDependencyFilteringStrategy.getCommonPrefixLength(uniformPath, path)).reversed();
        Comparator<String> nearestNeighborComparator = distanceComparator.thenComparing(commonPrefixComparator);
        return paths.stream().sorted().min(nearestNeighborComparator).orElseThrow(IllegalArgumentException::new);
    }

    @VisibleForTesting
    public static int getDistance(String uniformPath1, String uniformPath2) {
        String[] parts1 = UniformPathUtils.splitPath((String)uniformPath1);
        String[] parts2 = UniformPathUtils.splitPath((String)uniformPath2);
        int common = NearestNeighborFileDependencyFilteringStrategy.getCommonPrefixLength(uniformPath1, uniformPath2);
        return parts1.length + parts2.length - 2 * common;
    }

    @VisibleForTesting
    public static int getCommonPrefixLength(String uniformPath1, String uniformPath2) {
        String[] parts1 = UniformPathUtils.splitPath((String)uniformPath1);
        String[] parts2 = UniformPathUtils.splitPath((String)uniformPath2);
        int common = 0;
        for (int i = 0; i < parts1.length && i < parts2.length && parts1[i].equals(parts2[i]); ++i) {
            ++common;
        }
        return common;
    }
}

