/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Index(name="variable-write-dependencies", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED})
public class VariableWriteDependencyIndex
implements IProjectIndex {
    private final ValueIndex<TreeSet<String>> delegate;

    public VariableWriteDependencyIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void addVariableWrites(String variableName, Collection<String> typesToAdd) throws StorageException {
        TreeSet<String> types = (TreeSet<String>)this.delegate.getValue(variableName);
        if (types == null) {
            types = new TreeSet<String>();
        }
        types.addAll(typesToAdd);
        this.delegate.setValue(variableName, types);
    }

    public void removeVariableWritesForTypes(List<String> typesToRemove) throws StorageException {
        PairList toBeReset = new PairList();
        for (Pair entry : this.delegate.getAllEntries()) {
            HashSet toBeRemoved = CollectionUtils.intersectionSet(typesToRemove, (Collection[])new Collection[]{(Collection)entry.getSecond()});
            if (toBeRemoved.isEmpty()) continue;
            ((TreeSet)entry.getSecond()).removeAll(toBeRemoved);
            toBeReset.add((Object)((String)entry.getFirst()), (Object)((TreeSet)entry.getSecond()));
        }
        this.delegate.setValues(toBeReset);
    }

    public TreeSet<String> getVariableWrites(String variableName) throws StorageException {
        return (TreeSet)this.delegate.getValue(variableName);
    }
}

