/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.cs;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.conqat.lib.commons.string.StringUtils;

public abstract class CsTypeVisitorBase
implements IShallowEntityVisitor {
    protected static final Set<String> TYPE_SUBTYPES = CsTypeVisitorBase.asLowercaseText(ETokenType.CLASS, ETokenType.ENUM, ETokenType.INTERFACE, ETokenType.STRUCT, ETokenType.DELEGATE, ETokenType.RECORD);
    private static final Set<String> SCOPE_SUBTYPES = CsTypeVisitorBase.asLowercaseText(ETokenType.NAMESPACE, ETokenType.CLASS, ETokenType.ENUM, ETokenType.INTERFACE, ETokenType.STRUCT, ETokenType.DELEGATE, ETokenType.RECORD);
    private final Stack<String> currentScope = new Stack();
    private final boolean includeDelegates;

    protected CsTypeVisitorBase(boolean includeDelegates) {
        this.includeDelegates = includeDelegates;
    }

    public boolean visit(ShallowEntity entity) {
        String subtype = entity.getSubtype().toLowerCase();
        switch (entity.getType()) {
            case MODULE: {
                if (!subtype.equals(ETokenType.NAMESPACE.name().toLowerCase())) break;
                this.appendNamespacePart(entity.getName());
                break;
            }
            case TYPE: 
            case METHOD: {
                if (!this.includeDelegates && CsTypeVisitorBase.isDelegate(entity) || !TYPE_SUBTYPES.contains(subtype)) break;
                this.visitType(entity);
                this.appendNamespacePart(entity.getName());
            }
        }
        return true;
    }

    private static boolean isDelegate(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.METHOD && entity.getSubtype().toLowerCase().equals(ETokenType.DELEGATE.name().toLowerCase());
    }

    protected String getCurrentNamespace() {
        return StringUtils.concat(this.currentScope, (String)".");
    }

    protected abstract void visitType(ShallowEntity var1);

    private void appendNamespacePart(String identifier) {
        this.currentScope.push(identifier);
    }

    protected static String toQualifiedName(String namespace, String name) {
        if (StringUtils.isEmpty((String)namespace)) {
            return name;
        }
        return namespace + "." + name;
    }

    private static Set<String> asLowercaseText(ETokenType ... keywords) {
        HashSet<String> result = new HashSet<String>();
        for (ETokenType keyword : keywords) {
            result.add(keyword.name().toLowerCase());
        }
        return result;
    }

    public void endVisit(ShallowEntity entity) {
        switch (entity.getType()) {
            case MODULE: 
            case TYPE: 
            case METHOD: {
                if (!this.includeDelegates && CsTypeVisitorBase.isDelegate(entity) || !SCOPE_SUBTYPES.contains(entity.getSubtype().toLowerCase())) break;
                this.currentScope.pop();
            }
        }
    }
}

