/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.hana_view;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class HanaViewDependenciesUtils {
    private static final Pattern UNIFORM_PATH_PATTERN = Pattern.compile("(?<path>.*/)(?<name>[^/]+)\\.(?<type>[^/.]+)$");
    private static final Pattern RESOURCE_URI_VIEW_PATTERN = Pattern.compile("/(?<path>[^/]+/)(?<typeAndName>[^/]+/[^/]+)");
    private static final Pattern TABLE_ID_PATTERN = Pattern.compile("^(.*\\$+)?(?<path>.*?)::(?<name>.*?)\\$*$");

    static String resourceUriToTypeName(String resourceUri) throws ConQATException {
        Matcher resourceUriViewPattern = RESOURCE_URI_VIEW_PATTERN.matcher(resourceUri);
        if (resourceUriViewPattern.matches()) {
            return resourceUriViewPattern.group("path").replace('/', '.') + resourceUriViewPattern.group("typeAndName").replace('/', '.');
        }
        Matcher tableIdPattern = TABLE_ID_PATTERN.matcher(resourceUri);
        if (tableIdPattern.matches()) {
            return tableIdPattern.group("path").replace('/', '.') + ".hdbtablefunctions." + tableIdPattern.group("name");
        }
        throw new ConQATException("Cannot create dependency, resource URI " + resourceUri + " does not match " + RESOURCE_URI_VIEW_PATTERN.pattern() + " or " + TABLE_ID_PATTERN.pattern());
    }

    static String uniformPathToTypeName(String uniformPath) throws ConQATException {
        Matcher m = UNIFORM_PATH_PATTERN.matcher(uniformPath);
        if (!m.matches()) {
            throw new ConQATException("Cannot create dependency, uniform path " + uniformPath + " does not match " + UNIFORM_PATH_PATTERN.pattern());
        }
        return m.group("path").replace('/', '.') + m.group("type") + "s." + m.group("name");
    }

    static String tableIdToTypeName(String tableId, boolean includeStandardTables) {
        Matcher m = TABLE_ID_PATTERN.matcher(tableId);
        if (!m.matches()) {
            if (includeStandardTables) {
                return tableId;
            }
            return null;
        }
        return m.group("path").replace('/', '.') + "." + m.group("name");
    }

    private HanaViewDependenciesUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

