/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.hana_view;

import com.teamscale.index.dependencies.DependencyExtractionIndexes;
import com.teamscale.index.dependencies.DependencyExtractionSettings;
import com.teamscale.index.dependencies.IDependencyExtractor;
import com.teamscale.index.dependencies.ITypeLookupEnvironment;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.hana_view.HanaDependencyExtractionHandler;
import com.teamscale.index.dependencies.hana_view.HanaViewDependenciesUtils;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HanaViewDependencyExtractor
implements IDependencyExtractor {
    private static final String ATTRIBUTE_OR_TEXT_NODE_END = "(?:\"|\\s*<)";
    private Set<String> referencedResourceUris;
    private Set<String> referencedTableIds;

    @Override
    public List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo, DependencyExtractionIndexes dependencyExtractionIndexes, ITypeLookupEnvironment typeLookupEnvironment, DependencyExtractionSettings parameterObject) throws ConQATException {
        String referencedTypeName;
        String content = tokenElementInfo.getText();
        this.parseXmlContent(content);
        String uniformPath = tokenElementInfo.getUniformPath();
        LineOffsetConverter offsetConverter = new LineOffsetConverter(content);
        ListMap referencedTypes = new ListMap();
        for (String resourceUri : this.referencedResourceUris) {
            referencedTypeName = HanaViewDependenciesUtils.resourceUriToTypeName(resourceUri);
            if (!parameterObject.includeThirdPartyDependencies && !typeLookupEnvironment.isKnownType(referencedTypeName)) continue;
            referencedTypes.addAll((Object)referencedTypeName, HanaViewDependencyExtractor.getLocations(uniformPath, content, resourceUri, offsetConverter));
        }
        for (String tableId : this.referencedTableIds) {
            referencedTypeName = HanaViewDependenciesUtils.tableIdToTypeName(tableId, parameterObject.includeThirdPartyDependencies);
            if (referencedTypeName == null) continue;
            referencedTypes.addAll((Object)referencedTypeName, HanaViewDependencyExtractor.getLocations(uniformPath, content, tableId, offsetConverter));
        }
        String ownTypeName = HanaViewDependenciesUtils.uniformPathToTypeName(uniformPath);
        return Arrays.asList(new TypeDependencies(ownTypeName, (ListMap<String, ElementLocation>)referencedTypes));
    }

    private void parseXmlContent(String content) throws ConQATException {
        try {
            HanaDependencyExtractionHandler handler = new HanaDependencyExtractionHandler();
            XMLUtils.parseSAX((InputSource)new InputSource(new StringReader(content)), (DefaultHandler)handler);
            this.referencedResourceUris = handler.getReferencedResourceUris();
            this.referencedTableIds = handler.getReferencedTableIds();
        }
        catch (IOException | SAXException e) {
            throw new ConQATException("Error while parsing XML content", (Throwable)e);
        }
    }

    private static Set<TextRegionLocation> getLocations(String uniformPath, String content, String rawDependencyReference, LineOffsetConverter offsetConverter) {
        HashSet<TextRegionLocation> locations = new HashSet<TextRegionLocation>();
        Matcher matcher = Pattern.compile(Pattern.quote(rawDependencyReference) + ATTRIBUTE_OR_TEXT_NODE_END).matcher(content);
        while (matcher.find()) {
            int startOffset = matcher.start();
            int endOffset = startOffset + rawDependencyReference.length();
            locations.add(new TextRegionLocation(uniformPath, startOffset, endOffset, offsetConverter.getLine(startOffset), offsetConverter.getLine(endOffset)));
        }
        return locations;
    }
}

