/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.java;

import com.google.common.collect.ImmutableSet;
import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class JvmDependencyExtractorBase
extends DependencyExtractorBase {
    protected final Set<ETokenType> commonCases = ImmutableSet.of((Object)ETokenType.PACKAGE, (Object)ETokenType.DOT, (Object)ETokenType.MULT, (Object)ETokenType.CLASS_LITERAL, (Object)ETokenType.IDENTIFIER);
    public final PairList<String, TextRegionLocation> starImports = new PairList();
    public final PairList<String, TextRegionLocation> typeImports = new PairList();
    protected String ownPackage;
    protected String ownTypeName;
    protected boolean inImport;
    protected boolean inStaticImport;
    protected boolean inPackage;

    protected JvmDependencyExtractorBase(ETokenType ... namespaceSeparators) {
        super(namespaceSeparators);
    }

    protected List<TypeDependencies> collectDependencies() throws ConQATException {
        int i;
        ListMap dependencies = new ListMap();
        for (i = 0; i < this.typeImports.size(); ++i) {
            String typeImport = (String)this.typeImports.getFirst(i);
            String resolved = this.resolveImportedType(typeImport, this.settings.includeThirdPartyDependencies);
            if (resolved == null && !JvmDependencyExtractorBase.isJavaStandardApiType(typeImport)) {
                this.typeLookupEnvironment.registerUnresolvedType(typeImport);
                continue;
            }
            if (resolved == null || resolved.equals(this.ownTypeName)) continue;
            dependencies.add((Object)resolved, (Object)((ElementLocation)this.typeImports.getSecond(i)));
        }
        for (i = 0; i < this.identifiers.size(); ++i) {
            String resolvedType = this.resolveType((String)this.identifiers.getFirst(i));
            if (resolvedType == null || resolvedType.equals(this.ownTypeName)) continue;
            dependencies.add((Object)resolvedType, (Object)((ElementLocation)this.identifiers.getSecond(i)));
        }
        if (this.settings.includeThirdPartyDependencies) {
            for (i = 0; i < this.starImports.size(); ++i) {
                String importedEntity = (String)this.starImports.getFirst(i);
                String packageName = JvmDependencyExtractorBase.getPackageFromStarImport(importedEntity);
                if (this.typeLookupEnvironment.hasTypeWithPrefix(packageName + ".")) continue;
                dependencies.add((Object)importedEntity, (Object)((ElementLocation)this.starImports.getSecond(i)));
            }
        }
        return Collections.singletonList(new TypeDependencies(this.ownTypeName, (ListMap<String, ElementLocation>)dependencies));
    }

    private static boolean isJavaStandardApiType(String fullQualifiedClassname) {
        return StringUtils.startsWithOneOf((String)fullQualifiedClassname, (String[])new String[]{"java.", "javax."});
    }

    protected void handleEndOfStatement() {
        if (this.inImport) {
            if (this.inStaticImport) {
                if (ETokenType.MULT == this.previousTokenType) {
                    this.removeLastPartOfCurrentIdentifier(ETokenType.DOT);
                    this.typeImports.add((Object)this.getCurrentIdentifierText(), (Object)JvmDependencyExtractorBase.createLocation(this.uniformPath, this.currentIdentifierTokens));
                }
                this.addCurrentIdentifier(this.uniformPath);
            } else if (ETokenType.MULT == this.previousTokenType) {
                this.starImports.add((Object)this.getCurrentIdentifierText(), (Object)JvmDependencyExtractorBase.createLocation(this.uniformPath, this.currentIdentifierTokens));
            } else {
                if (this.currentIdentifierTokens.isEmpty()) {
                    return;
                }
                this.typeImports.add((Object)this.getCurrentIdentifierText(), (Object)JvmDependencyExtractorBase.createLocation(this.uniformPath, this.currentIdentifierTokens));
            }
        } else if (this.inPackage) {
            this.ownPackage = this.getCurrentIdentifierText();
        } else if (this.inIdentifier) {
            this.addCurrentIdentifier(this.uniformPath);
        }
        this.resetAtTheEndOfStatement();
    }

    @Override
    protected void handleIdentifier(IToken token) {
        if (this.previousTokenType == ETokenType.IDENTIFIER) {
            this.handleEndOfStatement();
        }
        this.inIdentifier = true;
        this.currentIdentifierTokens.add(token);
    }

    protected void resetFieldsBeforeExtraction() {
        this.typeImports.clear();
        this.starImports.clear();
        this.ownPackage = null;
        this.ownTypeName = null;
    }

    protected void resetAtTheEndOfStatement() {
        this.currentIdentifierTokens.clear();
        this.inImport = false;
        this.inStaticImport = false;
        this.inIdentifier = false;
        this.inPackage = false;
    }

    protected String resolveType(String identifier) throws ConQATException {
        boolean qualifiedIdentifier;
        boolean bl = qualifiedIdentifier = identifier.indexOf(46) != -1;
        if (!qualifiedIdentifier) {
            return this.resolveUnqualifiedType(identifier);
        }
        if (this.typeLookupEnvironment.isKnownType(identifier)) {
            return identifier;
        }
        return this.resolveType(StringUtils.removeLastPart((String)identifier, (char)'.'));
    }

    protected String resolveUnqualifiedType(String identifier) throws ConQATException {
        for (String typeImport : this.typeImports.extractFirstList()) {
            if (!typeImport.endsWith("." + identifier)) continue;
            return this.resolveType(typeImport);
        }
        String type = this.ownPackage + "." + identifier;
        if (this.typeLookupEnvironment.isKnownType(type)) {
            return type;
        }
        for (String starImport : this.starImports.extractFirstList()) {
            type = JvmDependencyExtractorBase.getPackageFromStarImport(starImport) + "." + identifier;
            if (!this.typeLookupEnvironment.isKnownType(type)) continue;
            return type;
        }
        return null;
    }

    private static String getPackageFromStarImport(String starImport) {
        return starImport.substring(0, starImport.length() - 2);
    }

    @Override
    public List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws ConQATException {
        this.resetFieldsBeforeExtraction();
        this.ownTypeName = JvmDependencyExtractorBase.getFullyQualifiedClassName(this.uniformPath, tokenElementInfo);
        for (IToken token : JvmDependencyExtractorBase.getRawTokensWithoutComments(tokenElementInfo)) {
            this.extractDependenciesForToken(token);
        }
        return this.collectDependencies();
    }

    protected void handleCommonCase(IToken token) {
        switch (token.getType()) {
            case PACKAGE: {
                this.inPackage = true;
                break;
            }
            case DOT: 
            case MULT: {
                if (!this.inIdentifier) break;
                this.currentIdentifierTokens.add(token);
                break;
            }
            case CLASS_LITERAL: {
                if (!this.inIdentifier || this.previousTokenType != ETokenType.DOT) break;
                this.currentIdentifierTokens.remove(this.currentIdentifierTokens.size() - 1);
                break;
            }
            case IDENTIFIER: {
                this.handleIdentifier(token);
                break;
            }
        }
    }

    protected void extractDependenciesForToken(IToken token) {
        ETokenType type = token.getType();
        if (this.commonCases.contains(type)) {
            this.handleCommonCase(token);
        } else if (type == ETokenType.STATIC) {
            if (this.inImport) {
                this.inStaticImport = true;
            }
        } else if (type == ETokenType.IMPORT) {
            this.inImport = true;
        } else {
            this.handleEndOfStatement();
        }
        this.previousTokenType = token.getType();
    }

    private static String getFullyQualifiedClassName(String path, TokenElementInfo tokenElementInfo) {
        String packageNamePrefix = LanguageFeatureParser.JAVA.getPackageName(tokenElementInfo.getShallowEntitiesWithPreprocessorTokens()).map(s -> s + ".").orElse("");
        return packageNamePrefix + JvmDependencyExtractorBase.getClassName(path);
    }

    private static String getClassName(String path) {
        String result = path.substring(0, path.length() - UniformPathUtils.getExtension((String)path).length() - 1);
        int index = FileSystemUtils.normalizeSeparators((String)result).lastIndexOf(47);
        if (index < 0) {
            return result;
        }
        return result.substring(index + 1);
    }
}

