/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.matlab;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class MatlabDependencyExtractor
extends DependencyExtractorBase {
    private final ListMap<String, ElementLocation> dependencies = new ListMap();

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) {
        List<ShallowEntity> rawEntities = tokenElementInfo.getRawShallowEntities();
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(rawEntities, (EShallowEntityType)EShallowEntityType.STATEMENT);
        List methods = ShallowEntityTraversalUtils.listMethodsNonRecursive(rawEntities);
        for (ShallowEntity statement : statements) {
            this.extractDependenciesFromStatement(statement, methods);
        }
        return Collections.singletonList(new TypeDependencies(this.uniformPath, this.dependencies));
    }

    private void extractDependenciesFromStatement(ShallowEntity statement, List<ShallowEntity> methods) {
        List<String> identifiers = MatlabDependencyExtractor.getIdentifiers(statement);
        for (String identifier : identifiers) {
            if (!this.typeLookupEnvironment.isKnownType(identifier) || MatlabDependencyExtractor.isLocalOrNestedFunction(identifier, methods)) continue;
            this.dependencies.add((Object)identifier, (Object)MatlabDependencyExtractor.createLocation(this.uniformPath, (List<IToken>)statement.includedTokens()));
        }
    }

    private static boolean isLocalOrNestedFunction(String functionName, List<ShallowEntity> methods) {
        if (methods.size() == 1) {
            return false;
        }
        for (int i = 1; i < methods.size(); ++i) {
            if (!methods.get(i).getName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getIdentifiers(ShallowEntity statement) {
        ArrayList<String> result = new ArrayList<String>();
        UnmodifiableList tokens = statement.ownStartTokens();
        List indentifierIndexes = TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)ETokenType.IDENTIFIER);
        for (Integer index : indentifierIndexes) {
            result.add(((IToken)tokens.get(index)).getText());
        }
        return result;
    }
}

