/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.teamscale.commons.lang.ToStringHelpers;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class ExternalProcessStepInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String NUMERIC_METRICS_PROPERTY = "numericMetrics";
    private static final String ASSESSMENT_METRICS_PROPERTY = "assessmentMetrics";
    @JsonProperty(value="description")
    private final @Nullable String description;
    @JsonProperty(value="numericMetrics")
    private final Map<String, Number> numericMetrics = new HashMap<String, Number>();
    @JsonProperty(value="assessmentMetrics")
    private final Map<String, Assessment> assessmentMetrics = new HashMap<String, Assessment>();

    @JsonCreator
    public ExternalProcessStepInfo(@JsonProperty(value="description") @Nullable String description, @JsonProperty(value="numericMetrics") Map<String, Number> numericMetrics, @JsonProperty(value="assessmentMetrics") Map<String, Assessment> assessmentMetrics) {
        Sets.SetView duplicateKeys = Sets.intersection(numericMetrics.keySet(), assessmentMetrics.keySet());
        Preconditions.checkArgument((boolean)duplicateKeys.isEmpty(), (String)"Found duplicate keys: %s", (Object)duplicateKeys);
        this.description = description;
        this.numericMetrics.putAll(numericMetrics);
        this.assessmentMetrics.putAll(assessmentMetrics);
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public Map<String, Number> getNumericMetrics() {
        if (this.numericMetrics == null) {
            return new HashMap<String, Number>();
        }
        return this.numericMetrics;
    }

    public Map<String, Assessment> getAssessmentMetrics() {
        if (this.assessmentMetrics == null) {
            return new HashMap<String, Assessment>();
        }
        return this.assessmentMetrics;
    }

    public Map<String, Object> getAllMetrics() {
        HashMap<String, Object> allMetrics = HashMap.newHashMap(this.getNumericMetrics().size() + this.getAssessmentMetrics().size());
        allMetrics.putAll(this.getNumericMetrics());
        allMetrics.putAll(this.getAssessmentMetrics());
        return allMetrics;
    }

    public static boolean isProcessArtifactPath(String uniformPath) {
        return UniformPathCompatibilityUtil.convert((String)uniformPath).isNonCodePath();
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

