/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.jspecify.annotations.NonNull;

public abstract class SessionBasedExternalAnalysisResultsTriggerBase
extends PrivilegedTriggerBase {
    private final List<String> messages = new ArrayList<String>();

    protected void storeProcessingStatus(boolean isSuccessful, ExternalAnalysisSessionInfo session, CommitDescriptor actualCommit, ExternalAnalysisStatusIndex statusIndex, Set<EExternalAnalysisResultType> types) throws StorageException {
        statusIndex.runWithLock(lockedIndex -> this.storeProcessingStatus((ExternalAnalysisStatusIndex.LockedIndexAccess)lockedIndex, isSuccessful, session, actualCommit, types));
    }

    private void storeProcessingStatus(ExternalAnalysisStatusIndex.LockedIndexAccess lockedIndex, boolean isSuccessful, ExternalAnalysisSessionInfo session, CommitDescriptor actualCommit, Set<EExternalAnalysisResultType> types) throws StorageException {
        ExternalAnalysisStatusInfo oldStatus = lockedIndex.getStatus(session.getCommit());
        ExternalAnalysisStatusInfo status = ExternalAnalysisStatusInfo.copy(oldStatus, () -> new ExternalAnalysisStatusInfo(actualCommit, true, session.getUploadTimestamp(), session.getTargetStorage().isPresent()));
        if (!session.getCommit().equals((Object)actualCommit)) {
            lockedIndex.removeStatus(status);
            status.setCommit(actualCommit);
        }
        status.setMessage(session.getMessage());
        ExternalAnalysisProcessingStepInfo step = session.getTargetStorage().isPresent() ? new ExternalAnalysisProcessingStepInfo(isSuccessful ? EExternalAnalysisProcessingStatus.STORED : EExternalAnalysisProcessingStatus.FAILED, isSuccessful, session.isMigrated()) : new ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus.STORED, isSuccessful, session.isMigrated());
        step.addMessages(this.messages);
        types.forEach(status::addType);
        status.addProcessingStep(step);
        lockedIndex.updateStatusWithKnownOldStatus(oldStatus, status);
    }

    protected static @NonNull ExternalAnalysisSessionInfo getSession(ExternalAnalysisImportSessionIndex sessionIndex, CommitDescriptor commit) throws StorageException, AssertionError {
        String sessionId = sessionIndex.getSessionIdByCommit(commit).orElseThrow(() -> new AssertionError((Object)"Could not find session ID for commit '%s'.".formatted(commit)));
        return SessionBasedExternalAnalysisResultsTriggerBase.getSession(sessionIndex, sessionId);
    }

    private static @NonNull ExternalAnalysisSessionInfo getSession(ExternalAnalysisImportSessionIndex sessionIndex, String sessionId) throws StorageException, AssertionError {
        ExternalAnalysisSessionInfo session = sessionIndex.getSessionInfo(sessionId).orElseThrow(() -> new AssertionError((Object)"Could not find session for id '%s'.".formatted(sessionId)));
        CCSMAssert.isTrue((!session.isOpen() ? 1 : 0) != 0, () -> "Session '%s' is not committed!".formatted(sessionId));
        return session;
    }

    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }

    public boolean canCauseSchedulingConflicts() {
        return false;
    }
}

