/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.IClientProvider;
import java.io.Serializable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NullMarked;

@NullMarked
@IndexValueClass(containedInBackup=true)
public record ExternalStorageBackend(String externalStorageBackendName, String credentialsName, EExternalStorageBackendProtocol backendProtocol, String repositoryOrBucketName, String uploadPathPrefix, boolean useS3CredentialsProcess) implements Serializable
{
    private static final long serialVersionUID = 1L;

    public ExternalStorageBackend {
        uploadPathPrefix = ExternalStorageBackend.normalizePathPrefix(uploadPathPrefix);
    }

    private static String normalizePathPrefix(String pathPrefix) {
        if (StringUtils.isEmpty((String)pathPrefix)) {
            return "";
        }
        return StringUtils.ensureEndsWith((String)StringUtils.stripAll((String)pathPrefix, (String)"/"), (String)"/");
    }

    public void validate(IExternalCredentialsProvider credentialsProvider) throws ConnectorValidationException, StorageException {
        if (StringUtils.isEmpty((String)this.externalStorageBackendName())) {
            throw new ConnectorValidationException("External storage name must be non-empty.");
        }
        if (StringUtils.isEmpty((String)this.credentialsName())) {
            throw new ConnectorValidationException("Credentials name must be non-empty.");
        }
        ExternalCredentials externalCredentials = credentialsProvider.getExternalCredentials(this.credentialsName());
        if (externalCredentials == null) {
            throw new ConnectorValidationException("Could not find the referenced credentials.");
        }
        if (StringUtils.isEmpty((String)this.repositoryOrBucketName())) {
            throw new ConnectorValidationException("Repository or bucket name must be non-empty.");
        }
    }

    public void testConnection(IClientProvider clientProvider) throws ConnectorValidationException, StorageException {
        try {
            clientProvider.createClient(this).testConnection(this.repositoryOrBucketName(), this.uploadPathPrefix());
        }
        catch (ProjectConfigurationException | RepositoryException e) {
            throw new ConnectorValidationException(e.getMessage(), e);
        }
    }
}

