/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.external_storage.migration.migrators;

import com.teamscale.index.external.input.external_storage.migration.migrators.CompileCommandMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.CoverageMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.DependencyInfoMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.ExecutionUnitMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.FindingMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.IExternalAnalysisResultsMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.IssuesMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.MetricSchemaChangeMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.MetricsMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.MultiFileRangeCoverageMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.ProcessStepInfoMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.SimulinkCodeGenerationMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.SpecItemsMigrator;
import com.teamscale.index.external.input.external_storage.migration.migrators.TestExecutionMigrator;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class ExternalAnalysisResultsMigratorProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, IExternalAnalysisResultsMigrator> MIGRATORS_BY_MIGRATED_TYPE = new HashMap<String, IExternalAnalysisResultsMigrator>();

    public static Set<IExternalAnalysisResultsMigrator> getMigratorsFor(Set<String> canonicalTypeNames) {
        HashSet<@NonNull IExternalAnalysisResultsMigrator> migrators = new HashSet<IExternalAnalysisResultsMigrator>();
        for (String canonicalTypeName : canonicalTypeNames) {
            IExternalAnalysisResultsMigrator migrator = MIGRATORS_BY_MIGRATED_TYPE.get(canonicalTypeName);
            if (migrator != null) {
                migrators.add(migrator);
                continue;
            }
            LOGGER.error("No migrator available for type '{}'.", (Object)canonicalTypeName);
        }
        return migrators;
    }

    static {
        Set<IExternalAnalysisResultsMigrator> migrators = Set.of(new CompileCommandMigrator(), new CoverageMigrator(), new DependencyInfoMigrator(), new ExecutionUnitMigrator(), new FindingMigrator(), new IssuesMigrator(), new MetricsMigrator(), new MetricSchemaChangeMigrator(), new ProcessStepInfoMigrator(), new SpecItemsMigrator(), new TestExecutionMigrator(), new MultiFileRangeCoverageMigrator(), new SimulinkCodeGenerationMigrator());
        for (IExternalAnalysisResultsMigrator migrator : migrators) {
            for (Class<ExternalAnalysisResult<?>> migratedType : migrator.getHandledTypes()) {
                MIGRATORS_BY_MIGRATED_TYPE.put(migratedType.getCanonicalName(), migrator);
            }
        }
    }
}

