/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public final class ExternalAnalysisProcessingStepInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String STATUS_PROPERTY = "status";
    private static final String SUCCESSFUL_PROPERTY = "successful";
    private static final String TIMESTAMP_PROPERTY = "timestamp";
    private static final String IS_STORAGE_MIGRATION_STEP_PROPERTY = "isStorageMigrationStep";
    @JsonProperty(value="status")
    private final EExternalAnalysisProcessingStatus status;
    @JsonProperty(value="successful")
    private final boolean successful;
    @JsonProperty(value="timestamp")
    private final long timestamp;
    @JsonProperty(value="messages")
    private @Nullable ArrayList<String> messages;
    @JsonProperty(value="isStorageMigrationStep")
    private boolean isStorageMigrationStep;

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalAnalysisProcessingStepInfo that = (ExternalAnalysisProcessingStepInfo)o;
        return this.successful == that.successful && this.timestamp == that.timestamp && this.status == that.status && Objects.equals(this.messages, that.messages) && this.isStorageMigrationStep == that.isStorageMigrationStep;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.successful, this.timestamp, this.messages, this.isStorageMigrationStep});
    }

    public ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus status, boolean successful) {
        this(status, successful, DateTimeUtils.millisNow(), false);
    }

    public ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus status, boolean successful, boolean isStorageMigrationStep) {
        this(status, successful, DateTimeUtils.millisNow(), isStorageMigrationStep);
    }

    @JsonCreator
    public ExternalAnalysisProcessingStepInfo(@JsonProperty(value="status") EExternalAnalysisProcessingStatus status, @JsonProperty(value="successful") boolean successful, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="isStorageMigrationStep") boolean isStorageMigrationStep) {
        this.status = status;
        this.successful = successful;
        this.timestamp = timestamp;
        this.isStorageMigrationStep = isStorageMigrationStep;
    }

    public ExternalAnalysisProcessingStepInfo copyWithUpdatedTimestamp() {
        return new ExternalAnalysisProcessingStepInfo(this.status, this.successful, this.isStorageMigrationStep);
    }

    public void addMessages(List<String> messages) {
        if (messages.isEmpty()) {
            return;
        }
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        this.messages.addAll(messages);
    }

    public void addMessage(String message) {
        this.addMessages(Collections.singletonList(message));
    }

    public EExternalAnalysisProcessingStatus getStatus() {
        return this.status;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<String> getMessages() {
        if (this.messages == null) {
            return Collections.emptyList();
        }
        return this.messages;
    }

    public boolean isStorageMigrationStep() {
        return this.isStorageMigrationStep;
    }
}

