/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.tools;

import com.teamscale.index.external.tools.BackupModifierToolBase;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.options.Option;

public class BranchedStoreReverter
extends BackupModifierToolBase {
    private final Set<String> storeNames = new HashSet<String>();

    @Override
    protected File checkPreconditions() {
        BranchedStoreReverter.exitIfTrue((boolean)this.getChangedStoreNames().isEmpty(), (String)"Must provide name of a store to modify!");
        return super.checkPreconditions();
    }

    @Override
    protected Set<String> getChangedStoreNames() {
        return CollectionUtils.asUnmodifiable(this.storeNames);
    }

    @Override
    protected void processStore(String storeName, IStore store, ZipArchiveOutputStream zos, BackupModifierToolBase.StoreFactory storeFactory) throws StorageException, IOException {
        CompressingStore compressedInputStore = new CompressingStore(store);
        BranchedStoreReverter.deleteCommitsAfter((IStore)compressedInputStore, this.endTimestamp);
        BranchedStoreReverter.writeOutputStore(zos, store);
    }

    private static void deleteCommitsAfter(IStore store, long timestamp) throws StorageException {
        CommitLayeringBranchingLayer branchingLayer = new CommitLayeringBranchingLayer(store, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
        HashSet<String> branchesToRecalculateHeadPointers = new HashSet<String>();
        for (byte[] commitKey : branchingLayer.getCommitKeys()) {
            Pair branchNameAndTimestamp = branchingLayer.parseCommitKey(commitKey);
            String branchName = (String)branchNameAndTimestamp.getFirst();
            long commitTimestamp = (Long)branchNameAndTimestamp.getSecond();
            if (commitTimestamp > timestamp) {
                branchingLayer.deleteCommit(commitKey);
                branchesToRecalculateHeadPointers.add(branchName);
                continue;
            }
            if (commitTimestamp != timestamp) continue;
            branchingLayer.unsealCommit(commitKey);
            branchesToRecalculateHeadPointers.add(branchName);
        }
        for (String branch : branchesToRecalculateHeadPointers) {
            branchingLayer.recalculateHeadCommitPointer(branch);
        }
    }

    @Option(shortName=115, longName="store", description="Add the name of a store to revert. Can be present multiple times.")
    public void addStoreName(String storeName) {
        this.storeNames.add(storeName);
    }

    public static void main(String[] args) {
        LoggingUtils.initLogger();
        BranchedStoreReverter.execute(BranchedStoreReverter::new, (String[])args);
    }
}

