/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.abaplint;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class ABAPLintConfigurationFile {
    public static final String DEFAULT_OPTION_EXCLUDE_FIELD = "exclude";
    public static final String DEFAULT_OPTION_SEVERITY_FIELD = "severity";
    private static final String LANGUAGE_VERSION_FIELD = "version";
    private static final String GLOBAL_SECTION_PARAMETER = "global";
    private static final String DEPENDENCIES_SECTION_PARAMETER = "dependencies";
    private static final String SYNTAX_SECTION_PARAMETER = "syntax";
    private static final String RULES_SECTION_PARAMETER = "rules";
    @JsonProperty(value="global")
    private Map<String, Object> global;
    @JsonProperty(value="dependencies")
    private List<Dependency> dependencies;
    @JsonProperty(value="syntax")
    private Map<String, Object> syntax;
    @JsonProperty(value="rules")
    private Map<String, LinkedHashMap<String, Object>> rules;

    @JsonCreator
    public ABAPLintConfigurationFile(@JsonProperty(value="global") Map<String, Object> global, @JsonProperty(value="dependencies") List<Dependency> dependencies, @JsonProperty(value="syntax") Map<String, Object> syntax, @JsonProperty(value="rules") Map<String, LinkedHashMap<String, Object>> rules) {
        this.global = global;
        this.dependencies = dependencies == null ? new ArrayList() : dependencies;
        this.syntax = syntax;
        this.rules = rules;
    }

    public Map<String, LinkedHashMap<String, Object>> getRules() {
        return this.rules;
    }

    public boolean hasLanguageVersion() {
        return this.syntax.containsKey(LANGUAGE_VERSION_FIELD);
    }

    public String getLanguageVersion() {
        if (this.hasLanguageVersion()) {
            return this.syntax.get(LANGUAGE_VERSION_FIELD).toString();
        }
        return "";
    }

    public boolean hasCheck(String rule) {
        return this.rules.containsKey(rule);
    }

    public Map<String, Object> getRuleOptions(String rule) {
        if (this.hasCheck(rule)) {
            return this.rules.get(rule);
        }
        return new LinkedHashMap<String, Object>();
    }

    public @Nullable String getOptionValueAsString(String rule, String optionName, String optionTypeName) {
        if (!this.hasCheck(rule) || this.getRuleOptions(rule).get(optionName) == null) {
            return null;
        }
        if (optionTypeName.equals(EToolCheckOptionType.JSON.getTypeName())) {
            return JsonUtils.serializeToJSON((Object)this.getRuleOptions(rule).get(optionName));
        }
        return this.getRuleOptions(rule).get(optionName).toString();
    }

    public void setLanguageVersion(String languageVersion) {
        this.syntax.put(LANGUAGE_VERSION_FIELD, languageVersion);
    }

    public void addDependencyFolder(String folder) {
        this.dependencies.add(new Dependency(null, folder, null));
    }

    public void addRuleWithDefaultOptions(String checkId) {
        LinkedHashMap<String, Object> defaultOptions = new LinkedHashMap<String, Object>();
        defaultOptions.put(DEFAULT_OPTION_EXCLUDE_FIELD, CollectionUtils.emptyList());
        defaultOptions.put(DEFAULT_OPTION_SEVERITY_FIELD, "Error");
        this.rules.put(checkId, defaultOptions);
    }

    public void addCheckOption(String checkId, String optionId, String optionTypeAsString, String optionValueAsString) throws JsonSerializationException {
        CCSMAssert.isTrue((boolean)this.rules.containsKey(checkId), (String)("No abapLint rule found for option " + optionId));
        this.rules.get(checkId).put(optionId, ABAPLintConfigurationFile.parseOptionValue(optionTypeAsString, optionValueAsString));
    }

    private static Object parseOptionValue(String optionType, String optionValueAsString) throws JsonSerializationException {
        return switch (optionType) {
            case "Boolean" -> Boolean.valueOf(optionValueAsString);
            case "Integer" -> Integer.valueOf(optionValueAsString);
            case "List" -> CollectionUtils.parseMultiValueStringToList((String)StringUtils.stripPrefix((String)StringUtils.stripSuffix((String)String.valueOf(optionValueAsString), (String)"]"), (String)"["), (boolean)true);
            case "JsonNode" -> JsonUtils.deserializeFromJson((String)optionValueAsString);
            default -> optionValueAsString == null ? "" : optionValueAsString;
        };
    }

    private record Dependency(String url, String folder, String files) {
    }
}

