/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.bandit;

import com.teamscale.core.utils.CSVParserBase;
import com.teamscale.core.utils.CsvStringListParser;
import com.teamscale.index.findings.bandit.FindingInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class BanditCSVReportParser {
    private static final CSVParserBase.Configuration CONFIG = new CSVParserBase.Configuration();

    public static List<FindingInfo> parse(@Nullable String report) throws ConQATException {
        if (StringUtils.isEmpty((String)report)) {
            return Collections.emptyList();
        }
        CsvStringListParser parser = new CsvStringListParser(CONFIG);
        StringReader reader = new StringReader(report);
        parser.parseAndWrapExceptions((Reader)reader);
        ArrayList<FindingInfo> findings = new ArrayList<FindingInfo>();
        for (List lineParts : parser) {
            if (((String)lineParts.get(0)).equals("filename")) continue;
            FindingInfo finding = BanditCSVReportParser.parseCSVRow(lineParts);
            findings.add(finding);
        }
        return findings;
    }

    private static FindingInfo parseCSVRow(List<String> rawLine) {
        String checkId = "bandit." + rawLine.get(2);
        int rowStart = Integer.parseInt(rawLine.get(7));
        String rowRange = rawLine.get(10);
        int rowEnd = BanditCSVReportParser.parseEndLine(rowRange);
        int columnStart = Integer.parseInt(rawLine.get(8));
        int columnEnd = Integer.parseInt(rawLine.get(9));
        String message = rawLine.get(6);
        String path = rawLine.get(0);
        return new FindingInfo(checkId, rowStart, rowEnd, columnStart, columnEnd, message, path);
    }

    private static int parseEndLine(String rowRange) {
        String lineEnd = StringUtils.removeAll((String)rowRange, (String[])new String[]{"[", "]"});
        lineEnd = StringUtils.getLastPart((String)lineEnd, (String)",").trim();
        return Integer.parseInt(lineEnd);
    }

    static {
        CONFIG.setDelimiterChar(',');
    }
}

